/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class NulljawRestGoal
extends Goal {
    private final Nulljaw drake;
    private int restingTicks;
    private int restDuration;
    private int retryCooldown;
    private RestState state;
    private int stateTimer;

    public NulljawRestGoal(Nulljaw drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.drake.m_21824_()) {
            return false;
        }
        if (this.drake.isSleepLocked()) {
            return false;
        }
        if (this.drake.m_20072_() || this.drake.m_20077_()) {
            return false;
        }
        if (this.drake.isDying() || this.drake.m_20160_()) {
            return false;
        }
        if (this.drake.m_5448_() != null || this.drake.m_5912_()) {
            return false;
        }
        if (this.drake.m_6069_()) {
            return false;
        }
        if (this.drake.getActiveAbility() != null) {
            return false;
        }
        return this.drake.m_217043_().m_188501_() < 5.0E-4f;
    }

    public boolean m_8045_() {
        if (this.state == null) {
            return false;
        }
        boolean safe = !this.drake.m_20072_() && this.drake.m_5448_() == null && !this.drake.m_5912_();
        boolean sequenceComplete = this.state == RestState.STANDING_UP && this.stateTimer > this.drake.getSitUpAnimationTicks() + 5;
        return safe && !sequenceComplete;
    }

    public void m_8056_() {
        this.restDuration = 80 + this.drake.m_217043_().m_188503_(81);
        this.restingTicks = 0;
        this.stateTimer = 0;
        this.state = RestState.SITTING_DOWN;
        this.drake.m_21839_(true);
        this.drake.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.drake.m_9236_().f_46443_) {
            return;
        }
        ++this.stateTimer;
        this.drake.m_21573_().m_26573_();
        this.drake.m_20334_(0.0, this.drake.m_20184_().f_82480_, 0.0);
        if (!(this.state != RestState.SITTING_DOWN && this.state != RestState.SITTING || this.drake.m_21827_())) {
            this.drake.m_21839_(true);
        }
        switch (this.state) {
            case SITTING_DOWN: {
                if (this.stateTimer <= this.drake.getSitDownAnimationTicks() + 5 || this.drake.isInSitTransition()) break;
                this.state = RestState.SITTING;
                this.stateTimer = 0;
                break;
            }
            case SITTING: {
                if (this.stateTimer <= 20) break;
                this.state = RestState.FALLING_ASLEEP;
                this.stateTimer = 0;
                this.drake.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.drake.m_5803_() || this.drake.isSleepTransitioning()) && this.stateTimer <= this.drake.getFallAsleepAnimationTicks() + 5) break;
                this.state = RestState.SLEEPING;
                this.stateTimer = 0;
                this.restingTicks = 0;
                break;
            }
            case SLEEPING: {
                ++this.restingTicks;
                if (this.restingTicks < this.restDuration) break;
                this.state = RestState.WAKING_UP;
                this.stateTimer = 0;
                this.drake.startSleepExit();
                this.drake.m_21839_(true);
                break;
            }
            case WAKING_UP: {
                if (this.stateTimer <= this.drake.getWakeUpAnimationTicks() + 5) break;
                this.state = RestState.SITTING_AFTER;
                this.stateTimer = 0;
                this.drake.m_21839_(true);
                break;
            }
            case SITTING_AFTER: {
                if (this.stateTimer <= 20) break;
                this.state = RestState.STANDING_UP;
                this.stateTimer = 0;
                this.drake.m_21839_(false);
                break;
            }
        }
    }

    public void m_8041_() {
        if (this.state != RestState.STANDING_UP) {
            if (this.drake.m_5803_() || this.drake.isSleepTransitioning()) {
                this.drake.startSleepExit();
            }
            this.drake.m_21839_(false);
        }
        this.retryCooldown = 200 + this.drake.m_217043_().m_188503_(201);
        this.restingTicks = 0;
        this.restDuration = 0;
        this.stateTimer = 0;
        this.state = null;
    }

    public boolean m_6767_() {
        return true;
    }

    private static enum RestState {
        SITTING_DOWN,
        SITTING,
        FALLING_ASLEEP,
        SLEEPING,
        WAKING_UP,
        SITTING_AFTER,
        STANDING_UP;

    }
}

