/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.common.registry.raevyx.RaevyxAbilities;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class RaevyxAttackGoal
extends Goal {
    protected final Raevyx wyvern;
    protected final int getAttackState;
    protected final int attackState;
    protected final int attackMaxTick;
    protected final int attackSeeTick;
    protected final float attackRange;

    public RaevyxAttackGoal(Raevyx wyvern, int getAttackState, int attackState, int attackMaxTick, int attackSeeTick, float attackRange) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        this.getAttackState = getAttackState;
        this.attackState = attackState;
        this.attackMaxTick = attackMaxTick;
        this.attackSeeTick = attackSeeTick;
        this.attackRange = attackRange;
    }

    public RaevyxAttackGoal(Raevyx wyvern, int getAttackState, int attackState, int attackMaxTick, int attackSeeTick, float attackRange, EnumSet<Goal.Flag> interruptFlagTypes) {
        this.wyvern = wyvern;
        this.m_7021_(interruptFlagTypes);
        this.getAttackState = getAttackState;
        this.attackState = attackState;
        this.attackMaxTick = attackMaxTick;
        this.attackSeeTick = attackSeeTick;
        this.attackRange = attackRange;
    }

    public boolean m_8036_() {
        if (this.wyvern.getAttackState() != this.getAttackState) {
            return false;
        }
        LivingEntity target = this.wyvern.m_5448_();
        if (target != null && target.m_6084_()) {
            double distanceSq = this.wyvern.m_20280_((Entity)target);
            return distanceSq <= this.getAttackReachSqr(target);
        }
        return false;
    }

    public void m_8056_() {
        this.wyvern.setAttackState(this.attackState);
        this.wyvern.m_21573_().m_26573_();
    }

    public void m_8041_() {
        LivingEntity target = this.wyvern.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.wyvern.m_6710_(null);
        }
        this.wyvern.m_21573_().m_26573_();
        if (this.wyvern.m_5448_() == null) {
            this.wyvern.m_21561_(false);
        }
    }

    public boolean m_8045_() {
        return this.wyvern.getAttackState() == this.attackState && this.wyvern.attackTicks <= this.attackMaxTick;
    }

    public void m_8037_() {
        LivingEntity target = this.wyvern.m_5448_();
        if (this.wyvern.attackTicks < this.attackSeeTick && target != null) {
            this.wyvern.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.wyvern.m_21391_((Entity)target, 30.0f, 30.0f);
        } else {
            this.wyvern.m_146922_(this.wyvern.f_19859_);
        }
        this.wyvern.m_21573_().m_26573_();
        this.executeAttack(target);
    }

    public boolean m_183429_() {
        return true;
    }

    private double getAttackReachSqr(LivingEntity target) {
        double combinedRadii = (double)(this.wyvern.m_20205_() + target.m_20205_()) * 0.5;
        double reach = (double)this.attackRange + combinedRadii;
        return reach * reach;
    }

    private void executeAttack(LivingEntity target) {
        if (target == null) {
            return;
        }
        switch (this.attackState) {
            case 2: {
                if (this.wyvern.attackTicks != 1) break;
                this.wyvern.tryActivateAbility(RaevyxAbilities.RAEVYX_HORN_GORE);
                break;
            }
            case 4: {
                if (this.wyvern.attackTicks != 1) break;
                this.wyvern.tryActivateAbility(RaevyxAbilities.RAEVYX_BITE);
            }
        }
    }
}

