/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaevyxFlightGoal
extends Goal {
    private final Raevyx wyvern;
    private Vec3 targetPosition;
    private int stuckCounter = 0;
    private int timeSinceTargetChange = 0;
    private static final int LANDING_COOLDOWN_TICKS = 100;
    private long lastLandingTime = 0L;
    private int flightDecisionCooldown = 0;
    private boolean wasThundering = false;
    private boolean wasRaining = false;

    public RaevyxFlightGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.flightDecisionCooldown = 0;
    }

    public boolean m_8036_() {
        boolean isFlying;
        LivingEntity owner;
        if (this.wyvern.isLanding()) {
            return false;
        }
        if (this.wyvern.m_20160_() || this.wyvern.m_20159_() || this.wyvern.m_21827_()) {
            return false;
        }
        if (!this.wyvern.m_6162_() && this.hasNearbyBabies() && !this.isOverDanger()) {
            return false;
        }
        boolean thundering = this.wyvern.m_9236_().m_46470_();
        boolean raining = !thundering && this.wyvern.m_9236_().m_46471_();
        boolean stormy = thundering || raining;
        boolean weatherChangedToStorm = thundering && !this.wasThundering || raining && !this.wasRaining;
        boolean weatherChangedToThunder = thundering && !this.wasThundering;
        this.wasThundering = thundering;
        this.wasRaining = raining;
        if (this.wyvern.m_21824_() && (owner = this.wyvern.m_269323_()) != null && this.wyvern.m_20280_((Entity)owner) < 225.0 && !this.isOverDanger()) {
            return false;
        }
        long currentTime = this.wyvern.m_9236_().m_46467_();
        int cooldown = 100;
        if (thundering) {
            cooldown = 0;
        } else if (raining) {
            cooldown /= 4;
        }
        if (weatherChangedToStorm) {
            cooldown = 0;
        }
        if (!this.wyvern.m_29443_() && currentTime - this.lastLandingTime < (long)cooldown) {
            return false;
        }
        int decisionInterval = this.flightDecisionInterval(thundering, raining);
        if (this.flightDecisionCooldown > 0) {
            --this.flightDecisionCooldown;
            if (this.flightDecisionCooldown > 0) {
                if (weatherChangedToThunder) {
                    this.flightDecisionCooldown = 0;
                } else if ((thundering || raining) && this.flightDecisionCooldown > decisionInterval) {
                    this.flightDecisionCooldown = decisionInterval;
                }
                if (this.flightDecisionCooldown > 0) {
                    return false;
                }
            }
        }
        if (isFlying = this.isOverDanger() ? true : (this.wyvern.m_29443_() ? this.shouldKeepFlying(thundering, raining) : this.shouldTakeOff(thundering, raining))) {
            this.targetPosition = this.findFlightTarget();
            this.flightDecisionCooldown = this.nextDecisionCooldown(decisionInterval);
            return true;
        }
        this.flightDecisionCooldown = this.nextDecisionCooldown(decisionInterval);
        return false;
    }

    public boolean m_8045_() {
        boolean raining;
        if (this.wyvern.isLanding()) {
            return false;
        }
        if (this.wyvern.m_21827_() || this.wyvern.m_20160_()) {
            return false;
        }
        if (this.wyvern.m_5448_() != null && this.wyvern.m_5448_().m_6084_()) {
            return false;
        }
        boolean thundering = this.wyvern.m_9236_().m_46470_();
        boolean bl = raining = !thundering && this.wyvern.m_9236_().m_46471_();
        if (this.wyvern.m_29443_() && !this.shouldKeepFlying(thundering, raining)) {
            this.wyvern.setLanding(true);
            this.wyvern.setFlying(false);
            this.wyvern.setTakeoff(false);
            this.wyvern.setHovering(false);
            return false;
        }
        return this.wyvern.m_29443_() && this.targetPosition != null && this.wyvern.m_20238_(this.targetPosition) > 9.0;
    }

    public void m_8056_() {
        this.wyvern.setFlying(true);
        this.wyvern.setTakeoff(false);
        this.wyvern.setLanding(false);
        this.wyvern.setHovering(false);
        if (this.targetPosition != null) {
            this.wyvern.m_21566_().m_6849_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, 1.0);
        }
    }

    public void m_8037_() {
        ++this.timeSinceTargetChange;
        if (this.wyvern.isLanding()) {
            return;
        }
        boolean needNewTarget = false;
        if (this.targetPosition == null) {
            needNewTarget = true;
        } else {
            double distanceToTarget = this.wyvern.m_20238_(this.targetPosition);
            if (distanceToTarget < 64.0) {
                needNewTarget = true;
            }
            if (this.wyvern.isFlightControllerStuck() && distanceToTarget > 25.0) {
                needNewTarget = true;
                this.stuckCounter = 0;
            }
            if (this.wyvern.f_19862_ && this.timeSinceTargetChange % 5 == 0) {
                ++this.stuckCounter;
                if (this.stuckCounter > 2) {
                    needNewTarget = true;
                    this.stuckCounter = 0;
                }
            } else if (!this.wyvern.f_19862_) {
                this.stuckCounter = Math.max(0, this.stuckCounter - 1);
            }
            if (this.wyvern.f_19797_ % 20 == 0 && !this.isValidFlightTarget(this.targetPosition)) {
                needNewTarget = true;
            }
            if (this.timeSinceTargetChange > 300) {
                needNewTarget = true;
            }
        }
        if (needNewTarget) {
            this.targetPosition = this.findFlightTarget();
            this.timeSinceTargetChange = 0;
            this.wyvern.m_21566_().m_6849_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, 1.0);
        }
    }

    public void m_8041_() {
        this.targetPosition = null;
        this.stuckCounter = 0;
        this.timeSinceTargetChange = 0;
        this.wyvern.m_21573_().m_26573_();
        if (!this.wyvern.m_29443_()) {
            this.lastLandingTime = this.wyvern.m_9236_().m_46467_();
        }
    }

    private Vec3 findFlightTarget() {
        Vec3 dragonPos = this.wyvern.m_20182_();
        for (int attempts = 0; attempts < 16; ++attempts) {
            Vec3 candidate = this.generateFlightCandidate(dragonPos, attempts);
            if (!this.isValidFlightTarget(candidate)) continue;
            return candidate;
        }
        return new Vec3(dragonPos.f_82479_, this.findSafeFlightHeight(dragonPos.f_82479_, dragonPos.f_82481_), dragonPos.f_82481_);
    }

    private Vec3 generateFlightCandidate(Vec3 dragonPos, int attempt) {
        boolean isStuck = this.wyvern.f_19862_ || this.stuckCounter > 0 || this.wyvern.isFlightControllerStuck();
        float maxRot = isStuck ? 360.0f : 180.0f;
        float range = isStuck ? 30.0f + this.wyvern.m_217043_().m_188501_() * 40.0f : 50.0f + this.wyvern.m_217043_().m_188501_() * 80.0f;
        float yRotOffset = isStuck && attempt < 8 ? (float)Math.toRadians(180.0f + this.wyvern.m_217043_().m_188501_() * 120.0f - 60.0f) : (float)Math.toRadians(this.wyvern.m_217043_().m_188501_() * maxRot - maxRot / 2.0f);
        float xRotOffset = (float)Math.toRadians((this.wyvern.m_217043_().m_188501_() - 0.5f) * 20.0f);
        Vec3 lookVec = this.wyvern.m_20154_();
        Vec3 targetVec = lookVec.m_82490_((double)range).m_82524_(yRotOffset).m_82496_(xRotOffset);
        Vec3 candidate = dragonPos.m_82549_(targetVec);
        double targetY = this.findSafeFlightHeight(candidate.f_82479_, candidate.f_82481_);
        candidate = new Vec3(candidate.f_82479_, targetY, candidate.f_82481_);
        if (!this.wyvern.m_9236_().m_46749_(BlockPos.m_274446_((Position)candidate))) {
            return null;
        }
        return candidate;
    }

    private double findSafeFlightHeight(double x, double z) {
        boolean raining;
        int ix = (int)x;
        int iz = (int)z;
        int groundY = this.wyvern.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ix, iz);
        double base = 15.0 + this.wyvern.m_217043_().m_188500_() * 20.0;
        boolean thundering = this.wyvern.m_9236_().m_46470_();
        boolean bl = raining = !thundering && this.wyvern.m_9236_().m_46471_();
        double capAboveGround = thundering ? 90.0 : (raining ? 70.0 : 50.0);
        double target = (double)groundY + base;
        double cap = (double)groundY + capAboveGround;
        double worldCap = (double)this.wyvern.m_9236_().m_151558_() - 10.0;
        return Math.min(Math.min(target, cap), worldCap);
    }

    private boolean isValidFlightTarget(Vec3 target) {
        double distanceToTarget;
        if (target == null) {
            return false;
        }
        BlockHitResult result = this.wyvern.m_9236_().m_45547_(new ClipContext(this.wyvern.m_146892_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.wyvern));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        double distanceToHit = result.m_82450_().m_82554_(this.wyvern.m_20182_());
        return distanceToHit > (distanceToTarget = target.m_82554_(this.wyvern.m_20182_())) * 0.95;
    }

    private int flightDecisionInterval(boolean thundering, boolean raining) {
        if (thundering) {
            return 2;
        }
        if (raining) {
            return 8;
        }
        return 25;
    }

    private int nextDecisionCooldown(int baseInterval) {
        int jitter = Math.max(1, baseInterval / 2);
        return baseInterval + this.wyvern.m_217043_().m_188503_(jitter);
    }

    private boolean shouldTakeOff(boolean thundering, boolean raining) {
        if (this.isOverDanger()) {
            return true;
        }
        if (thundering) {
            return this.wyvern.m_217043_().m_188503_(4) == 0;
        }
        if (raining) {
            return this.wyvern.m_217043_().m_188503_(8) == 0;
        }
        return this.wyvern.m_217043_().m_188503_(80) == 0;
    }

    private boolean shouldKeepFlying(boolean thundering, boolean raining) {
        if (this.isOverDanger()) {
            return true;
        }
        if (thundering) {
            return this.wyvern.m_217043_().m_188503_(3000) != 0;
        }
        if (raining) {
            return this.wyvern.m_217043_().m_188503_(1800) != 0;
        }
        return this.wyvern.m_217043_().m_188503_(200) != 0;
    }

    private boolean hasNearbyBabies() {
        return !this.wyvern.m_9236_().m_6443_(Raevyx.class, this.wyvern.m_20191_().m_82400_(16.0), baby -> baby != null && baby.m_6162_() && baby.m_6084_()).isEmpty();
    }

    private boolean isOverDanger() {
        BlockPos dragonPos = this.wyvern.m_20183_();
        boolean foundSolid = false;
        boolean nearFluid = false;
        for (int i = 1; i <= 25; ++i) {
            BlockPos checkPos = dragonPos.m_6625_(i);
            BlockState state = this.wyvern.m_9236_().m_8055_(checkPos);
            if (!state.m_60812_((BlockGetter)this.wyvern.m_9236_(), checkPos).m_83281_() || state.m_60783_((BlockGetter)this.wyvern.m_9236_(), checkPos, Direction.UP)) {
                foundSolid = true;
                break;
            }
            if (i > 10 || this.wyvern.m_9236_().m_6425_(checkPos).m_76178_()) continue;
            nearFluid = true;
        }
        if (nearFluid) {
            return true;
        }
        return !foundSolid && dragonPos.m_123342_() < this.wyvern.m_9236_().m_141937_() + 20;
    }
}

