/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class RaevyxRestGoal
extends Goal {
    private final Raevyx wyvern;
    private int restingTicks;
    private int restDuration;
    private int retryCooldown;
    private RestState state;
    private int stateTimer;

    public RaevyxRestGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.wyvern.m_21824_()) {
            return false;
        }
        if (this.wyvern.m_21827_()) {
            return false;
        }
        if (this.wyvern.isSleepLocked()) {
            return false;
        }
        if (this.wyvern.m_20072_() || this.wyvern.m_20077_()) {
            return false;
        }
        if (this.wyvern.isDying() || this.wyvern.m_20160_()) {
            return false;
        }
        if (this.wyvern.m_5448_() != null || this.wyvern.m_5912_()) {
            return false;
        }
        if (this.wyvern.m_29443_()) {
            return false;
        }
        return this.wyvern.m_217043_().m_188501_() < 5.0E-4f;
    }

    public boolean m_8045_() {
        boolean safeToRest = !this.wyvern.m_20072_() && this.wyvern.m_5448_() == null;
        boolean sequenceComplete = this.state == RestState.STANDING_UP && this.stateTimer > 20;
        return !sequenceComplete && safeToRest;
    }

    public void m_8056_() {
        this.restDuration = 100 + this.wyvern.m_217043_().m_188503_(101);
        this.restingTicks = 0;
        this.stateTimer = 0;
        this.state = RestState.SITTING_DOWN;
        this.wyvern.m_21839_(true);
        this.wyvern.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.wyvern.m_9236_().f_46443_) {
            return;
        }
        ++this.stateTimer;
        this.wyvern.m_21573_().m_26573_();
        this.wyvern.m_20334_(0.0, this.wyvern.m_20184_().f_82480_, 0.0);
        if (!(this.state != RestState.SITTING_DOWN && this.state != RestState.SITTING || this.wyvern.m_21827_())) {
            this.wyvern.m_21839_(true);
        }
        switch (this.state) {
            case SITTING_DOWN: {
                if (this.stateTimer <= 35 || this.wyvern.isInSitTransition()) break;
                this.state = RestState.SITTING;
                this.stateTimer = 0;
                break;
            }
            case SITTING: {
                if (this.stateTimer <= 20) break;
                this.state = RestState.FALLING_ASLEEP;
                this.stateTimer = 0;
                this.wyvern.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.wyvern.m_5803_() || this.wyvern.isSleepTransitioning()) && this.stateTimer <= 55) break;
                this.state = RestState.SLEEPING;
                this.stateTimer = 0;
                this.restingTicks = 0;
                break;
            }
            case SLEEPING: {
                ++this.restingTicks;
                if (this.restingTicks < this.restDuration) break;
                this.state = RestState.WAKING_UP;
                this.stateTimer = 0;
                this.wyvern.startSleepExit();
                this.wyvern.m_21839_(true);
                break;
            }
            case WAKING_UP: {
                if (this.stateTimer <= 58) break;
                this.state = RestState.SITTING_AFTER;
                this.stateTimer = 0;
                this.wyvern.m_21839_(true);
                break;
            }
            case SITTING_AFTER: {
                if (this.stateTimer <= 20) break;
                this.state = RestState.STANDING_UP;
                this.stateTimer = 0;
                this.wyvern.m_21839_(false);
                break;
            }
        }
    }

    public void m_8041_() {
        if (this.state != RestState.STANDING_UP) {
            if (this.wyvern.m_5803_() || this.wyvern.isSleepTransitioning()) {
                this.wyvern.startSleepExit();
            }
            this.wyvern.m_21839_(false);
        }
        this.retryCooldown = 200 + this.wyvern.m_217043_().m_188503_(201);
        this.restingTicks = 0;
        this.restDuration = 0;
        this.stateTimer = 0;
        this.state = null;
    }

    public boolean m_6767_() {
        return true;
    }

    private static enum RestState {
        SITTING_DOWN,
        SITTING,
        FALLING_ASLEEP,
        SLEEPING,
        WAKING_UP,
        SITTING_AFTER,
        STANDING_UP;

    }
}

