/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx.baby;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class RaevyxFollowParentGoal
extends Goal {
    private final Raevyx baby;
    private final double speedModifier;
    private Raevyx parent;
    private int timeToRecalcPath;
    private static final double MIN_DISTANCE_SQ = 25.0;
    private static final double MAX_DISTANCE_SQ = 256.0;
    private int wanderCooldown = 0;

    public RaevyxFollowParentGoal(Raevyx baby, double speedModifier) {
        this.baby = baby;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.baby.m_6162_() || this.baby.m_21824_()) {
            return false;
        }
        List nearby = this.baby.m_9236_().m_6443_(Raevyx.class, this.baby.m_20191_().m_82377_(12.0, 6.0, 12.0), adult -> adult != null && !adult.m_6162_() && adult.m_6084_());
        double closestDistance = Double.MAX_VALUE;
        Raevyx closestAdult = null;
        for (Raevyx adult2 : nearby) {
            double dist = this.baby.m_20280_((Entity)adult2);
            if (!(dist < closestDistance)) continue;
            closestDistance = dist;
            closestAdult = adult2;
        }
        if (closestAdult == null) {
            return false;
        }
        if (closestDistance < 25.0) {
            return false;
        }
        this.parent = closestAdult;
        return true;
    }

    public boolean m_8045_() {
        if (!this.baby.m_6162_() || this.baby.m_21824_()) {
            return false;
        }
        if (this.parent == null || !this.parent.m_6084_() || this.parent.m_6162_()) {
            return false;
        }
        double dist = this.baby.m_20280_((Entity)this.parent);
        return dist >= 25.0 && dist <= 256.0;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.wanderCooldown = 0;
    }

    public void m_8041_() {
        this.parent = null;
        this.baby.m_21573_().m_26573_();
        this.wanderCooldown = 0;
    }

    public void m_8037_() {
        if (this.parent == null) {
            return;
        }
        double distToParent = this.baby.m_20280_((Entity)this.parent);
        if (this.wanderCooldown > 0) {
            --this.wanderCooldown;
            if (distToParent > 50.0) {
                this.wanderCooldown = 0;
            }
            return;
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(12);
            this.baby.m_21573_().m_5624_((Entity)this.parent, this.speedModifier);
            if (distToParent < 30.0) {
                this.wanderCooldown = 20 + this.baby.m_217043_().m_188503_(20);
            }
        }
    }
}

