/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.stegonaut;

import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class StegonautFollowOwnerGoal
extends Goal {
    private final Stegonaut drake;
    private static final double START_FOLLOW_DIST = 12.0;
    private static final double STOP_FOLLOW_DIST = 8.0;
    private static final double TELEPORT_DIST = 2000.0;
    private int pathRecalcCooldown = 0;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public StegonautFollowOwnerGoal(Stegonaut drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.drake.m_21824_() || this.drake.m_21827_()) {
            return false;
        }
        if (this.drake.isPlayingDead()) {
            return false;
        }
        LivingEntity target = this.drake.m_5448_();
        if (target != null && target.m_6084_()) {
            return false;
        }
        LivingEntity owner = this.drake.m_269323_();
        if (owner == null || !owner.m_6084_()) {
            return false;
        }
        if (owner.m_9236_() != this.drake.m_9236_()) {
            return false;
        }
        double ownerDist = this.drake.m_20280_((Entity)owner);
        return ownerDist > 144.0;
    }

    public boolean m_8045_() {
        LivingEntity owner = this.drake.m_269323_();
        if (owner == null || !owner.m_6084_() || this.drake.m_21827_()) {
            return false;
        }
        if (this.drake.isPlayingDead()) {
            return false;
        }
        LivingEntity target = this.drake.m_5448_();
        if (target != null && target.m_6084_()) {
            return false;
        }
        if (owner.m_9236_() != this.drake.m_9236_()) {
            return false;
        }
        double dist = this.drake.m_20280_((Entity)owner);
        return dist > 64.0;
    }

    public void m_8056_() {
        this.resetPathTracking();
    }

    public void m_8037_() {
        LivingEntity owner = this.drake.m_269323_();
        if (owner == null) {
            return;
        }
        double distance = this.drake.m_20270_((Entity)owner);
        if (distance > 2000.0) {
            this.drake.m_6021_(owner.m_20185_(), owner.m_20186_() + 1.0, owner.m_20189_());
            this.resetPathTracking();
            return;
        }
        this.drake.m_21563_().m_24960_((Entity)owner, 10.0f, 10.0f);
        this.handleGroundFollowing(owner, distance);
    }

    private void handleGroundFollowing(LivingEntity owner, double distance) {
        if (distance <= 8.0) {
            this.drake.m_21573_().m_26573_();
            this.pathRecalcCooldown = 0;
            return;
        }
        double baseSpeed = 0.8;
        double speed = baseSpeed * (1.0 + distance / 100.0);
        speed = Math.min(speed, 1.0);
        this.updateGroundPath(owner, speed, distance);
        if (this.drake.m_21573_().m_26577_()) {
            this.drake.m_21569_().m_24901_();
            this.drake.m_21573_().m_26573_();
            this.pathRecalcCooldown = 0;
        }
    }

    public void m_8041_() {
        this.drake.m_21573_().m_26573_();
        this.resetPathTracking();
    }

    private void updateGroundPath(LivingEntity owner, double speed, double distance) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.drake.m_21573_().m_26571_() || !this.drake.m_21573_().m_26572_();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            if (!this.drake.m_21573_().m_5624_((Entity)owner, speed)) {
                this.drake.m_21573_().m_26519_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), speed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance);
        }
    }

    private int computeRepathCooldown(double distance) {
        int base = (int)Math.ceil(distance * 0.45);
        return Mth.m_14045_((int)base, (int)6, (int)24);
    }

    private boolean ownerMovedSignificantly(LivingEntity owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.m_20185_() - this.lastOwnerX;
        return dx * dx + (dy = owner.m_20186_() - this.lastOwnerY) * dy + (dz = owner.m_20189_() - this.lastOwnerZ) * dz > 1.0;
    }

    private void rememberOwnerPosition(LivingEntity owner) {
        this.lastOwnerX = owner.m_20185_();
        this.lastOwnerY = owner.m_20186_();
        this.lastOwnerZ = owner.m_20189_();
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }
}

