/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.cindervane;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CindervaneFireBodyAbility
extends DragonAbility<Cindervane> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 1), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 1000)};
    private static final double AURA_RADIUS = 3.5;
    private static final double AURA_VERTICAL = 2.5;
    private static final float BASE_DAMAGE = 3.0f;
    private static final int FIRE_SECONDS = 4;
    private static final int ALLY_FIRE_RESIST_TICKS = 60;
    private static final int ALLY_DAMAGE_RESIST_TICKS = 40;
    private int activeTicks;

    public CindervaneFireBodyAbility(DragonAbilityType<Cindervane, CindervaneFireBodyAbility> type, Cindervane user) {
        super(type, user, TRACK, 40);
    }

    @Override
    public boolean isOverlayAbility() {
        return true;
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.activeTicks = 0;
            ((Cindervane)this.getUser()).setBreathingFire(true);
            Level level = this.getLevel();
            level.m_5594_(null, ((Cindervane)this.getUser()).m_20183_(), SoundEvents.f_11874_, ((Cindervane)this.getUser()).m_5720_(), 1.2f, 1.0f + ((Cindervane)this.getUser()).m_217043_().m_188501_() * 0.2f);
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            ((Cindervane)this.getUser()).setBreathingFire(true);
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            ((Cindervane)this.getUser()).setBreathingFire(false);
        }
    }

    @Override
    public void interrupt() {
        ((Cindervane)this.getUser()).setBreathingFire(false);
        super.interrupt();
    }

    @Override
    protected boolean canContinueUsing() {
        Cindervane dragon = (Cindervane)this.getUser();
        if (!dragon.m_6084_() || dragon.m_213877_()) {
            return false;
        }
        return !dragon.m_20072_();
    }

    @Override
    public void tickUsing() {
        Cindervane dragon = (Cindervane)this.getUser();
        Level level = dragon.m_9236_();
        if (!level.f_46443_) {
            ++this.activeTicks;
            this.applyFireAura((ServerLevel)level, dragon);
            if (this.activeTicks % 20 == 0) {
                level.m_5594_(null, dragon.m_20183_(), SoundEvents.f_11705_, dragon.m_5720_(), 0.6f, 0.9f + dragon.m_217043_().m_188501_() * 0.2f);
            }
        }
    }

    private void applyFireAura(ServerLevel level, Cindervane dragon) {
        Vec3 center = dragon.m_20182_().m_82520_(0.0, (double)dragon.m_20206_() * 0.5, 0.0);
        AABB area = dragon.m_20191_().m_82377_(3.5, 2.5, 3.5);
        this.protectAllies(level, dragon, area);
        HashSet<LivingEntity> hitThisTick = new HashSet<LivingEntity>();
        for (LivingEntity target : level.m_6443_(LivingEntity.class, area, e -> e != dragon && e.m_6084_() && e.m_5789_() && !dragon.isAlly((Entity)e))) {
            if (!hitThisTick.add(target)) continue;
            float damage = 3.0f;
            target.m_6469_(level.m_269111_().m_269254_(), damage);
            target.m_20254_(4);
            Vec3 pushDir = target.m_20182_().m_82546_(center);
            if (!(pushDir.m_82556_() > 1.0E-4)) continue;
            pushDir = pushDir.m_82541_().m_82490_(0.15);
            target.m_5997_(pushDir.f_82479_, 0.05, pushDir.f_82481_);
        }
        RandomSource rng = dragon.m_217043_();
        for (int i = 0; i < 12; ++i) {
            double angle = rng.m_188500_() * (Math.PI * 2);
            double radius = 0.5 + rng.m_188500_() * 3.0;
            double height = rng.m_188500_() * 2.5;
            Vec3 sample = center.m_82520_(Math.cos(angle) * radius, -1.25 + height, Math.sin(angle) * radius);
            this.spawnParticles(level, sample);
            this.maybeIgnite(level, sample, dragon);
        }
    }

    private void spawnParticles(ServerLevel level, Vec3 sample) {
        double spread = 0.6;
        int flameCount = 12;
        int emberCount = 9;
        int smokeCount = 6;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, sample.f_82479_, sample.f_82480_, sample.f_82481_, flameCount, spread, spread * 0.6, spread, 0.05);
        level.m_8767_((ParticleOptions)ParticleTypes.f_175834_, sample.f_82479_, sample.f_82480_, sample.f_82481_, emberCount, spread * 0.4, spread * 0.25, spread * 0.4, 0.02);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, sample.f_82479_, sample.f_82480_, sample.f_82481_, 3, spread * 0.2, spread * 0.2, spread * 0.2, 0.07);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, sample.f_82479_, sample.f_82480_, sample.f_82481_, smokeCount, spread * 0.8, spread * 0.4, spread * 0.8, 0.0);
    }

    private void maybeIgnite(ServerLevel level, Vec3 sample, Cindervane dragon) {
        if (dragon.m_217043_().m_188501_() > 0.12f) {
            return;
        }
        BlockPos pos = BlockPos.m_274561_((double)sample.f_82479_, (double)(sample.f_82480_ - 0.5), (double)sample.f_82481_);
        if (!level.m_46749_(pos) || !level.m_46859_(pos)) {
            return;
        }
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        if (belowState.m_60795_()) {
            return;
        }
        if (Blocks.f_50083_.m_49966_().m_60710_((LevelReader)level, pos) && belowState.m_60783_((BlockGetter)level, below, Direction.UP)) {
            level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 11);
        }
    }

    private void protectAllies(ServerLevel level, Cindervane dragon, AABB area) {
        AABB expanded = area.m_82377_(1.5, 0.75, 1.5);
        for (LivingEntity ally : level.m_6443_(LivingEntity.class, expanded, entity -> entity != dragon && entity.m_6084_() && dragon.isAlly((Entity)entity))) {
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 60, 0, true, false, false));
            ally.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 4, true, false, false));
            ally.m_7311_(0);
        }
    }
}

