/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.nulljaw;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class NulljawBite2Ability
extends DragonAbility<Nulljaw> {
    private static final float BASE_DAMAGE = 50.0f;
    private static final double BASE_RANGE = 7.5;
    private static final double RIDDEN_RANGE_BONUS = 1.0;
    private static final double SWIM_RANGE_BONUS = 8.0;
    private static final double BITE_ANGLE_DEG = 95.0;
    private static final double BITE_SWIPE_HORIZONTAL = 5.5;
    private static final double BITE_SWIPE_HORIZONTAL_RIDDEN = 2.0;
    private static final double BITE_SWIPE_VERTICAL = 5.5;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 2)};
    private boolean appliedHit;

    public NulljawBite2Ability(DragonAbilityType<Nulljaw, NulljawBite2Ability> type, Nulljaw user) {
        super(type, user, TRACK, 8);
    }

    @Override
    public boolean tryAbility() {
        return ((Nulljaw)this.getUser()).isPhaseTwoActive();
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Nulljaw dragon = (Nulljaw)this.getUser();
            dragon.triggerAnim("action", "bite2");
            this.appliedHit = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.appliedHit) {
            double d;
            LivingEntity t;
            Nulljaw dragon = (Nulljaw)this.getUser();
            LivingEntity primary = this.findPrimaryTarget();
            if (primary == null && (t = dragon.m_5448_()) != null && t.m_6084_() && (d = (double)t.m_20270_((Entity)dragon)) <= 5.2) {
                primary = t;
            }
            if (primary == null) {
                boolean ridden = dragon.m_6688_() != null;
                double effectiveRange = this.getEffectiveRange();
                primary = this.raycastTargetAlongMouth(effectiveRange + 2.0, ridden ? 2.0 : 1.0);
            }
            if (primary != null) {
                this.applyHit(dragon, primary);
            }
            this.appliedHit = true;
        }
    }

    private void applyHit(Nulljaw dragon, LivingEntity target) {
        double value;
        float damage = 50.0f;
        AttributeInstance attackAttr = dragon.m_21051_(Attributes.f_22281_);
        if (attackAttr != null && (value = attackAttr.m_22135_()) > 0.0) {
            damage = (float)(value * 1.1);
        }
        DamageSource source = dragon.m_9236_().m_269111_().m_269333_((LivingEntity)dragon);
        target.m_6469_(source, damage);
        Vec3 push = dragon.m_20154_().m_82490_(0.35);
        target.m_5997_(push.f_82479_, dragon.m_6069_() ? 0.2 : 0.08, push.f_82481_);
    }

    private double getEffectiveRange() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        double range = 7.5;
        if (dragon.m_6688_() != null) {
            range += 1.0;
        }
        if (dragon.m_6069_()) {
            range += 8.0;
        }
        return range;
    }

    private LivingEntity findPrimaryTarget() {
        Nulljaw dragon = (Nulljaw)this.getUser();
        Vec3 mouth = dragon.getMouthPosition();
        Vec3 look = dragon.m_20154_().m_82541_();
        boolean ridden = dragon.m_6688_() != null;
        double effectiveRange = this.getEffectiveRange();
        double horizontalInflate = ridden ? 2.0 : 5.5;
        AABB forwardSweep = new AABB(mouth, mouth.m_82549_(look.m_82490_(effectiveRange))).m_82377_(horizontalInflate, 5.5, horizontalInflate);
        List candidates = dragon.m_9236_().m_6443_(LivingEntity.class, forwardSweep, e -> e != dragon && e.m_6084_() && e.m_5789_() && !dragon.isAlly((Entity)e));
        double cosLimit = Math.cos(Math.toRadians(95.0));
        LivingEntity best = null;
        double bestDist = Double.MAX_VALUE;
        for (LivingEntity e2 : candidates) {
            boolean goodAngle;
            Vec3 dir;
            double dot;
            Vec3 toward;
            double len;
            double distToAabb = NulljawBite2Ability.distancePointToAABB(mouth, e2.m_20191_());
            if (distToAabb > effectiveRange + 0.4 || (len = (toward = NulljawBite2Ability.closestPointOnAABB(mouth, e2.m_20191_()).m_82546_(mouth)).m_82553_()) <= 1.0E-4 || (dot = (dir = toward.m_82490_(1.0 / len)).m_82526_(look)) <= 0.0) continue;
            boolean veryClose = distToAabb < effectiveRange * 0.35;
            boolean bl = goodAngle = dot >= cosLimit;
            if (ridden) {
                boolean bl2 = goodAngle = goodAngle || dot >= cosLimit * 0.75;
            }
            if (!veryClose && !goodAngle || !(distToAabb < bestDist)) continue;
            bestDist = distToAabb;
            best = e2;
        }
        return best;
    }

    private static double distancePointToAABB(Vec3 p, AABB box) {
        double dx = Math.max(Math.max(box.f_82288_ - p.f_82479_, 0.0), p.f_82479_ - box.f_82291_);
        double dy = Math.max(Math.max(box.f_82289_ - p.f_82480_, 0.0), p.f_82480_ - box.f_82292_);
        double dz = Math.max(Math.max(box.f_82290_ - p.f_82481_, 0.0), p.f_82481_ - box.f_82293_);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static Vec3 closestPointOnAABB(Vec3 p, AABB box) {
        double cx = Mth.m_14008_((double)p.f_82479_, (double)box.f_82288_, (double)box.f_82291_);
        double cy = Mth.m_14008_((double)p.f_82480_, (double)box.f_82289_, (double)box.f_82292_);
        double cz = Mth.m_14008_((double)p.f_82481_, (double)box.f_82290_, (double)box.f_82293_);
        return new Vec3(cx, cy, cz);
    }

    private LivingEntity raycastTargetAlongMouth(double maxDistance, double inflateRadius) {
        Entity entity;
        Nulljaw dragon = (Nulljaw)this.getUser();
        Vec3 start = dragon.getMouthPosition();
        Vec3 look = dragon.m_20154_().m_82541_();
        Vec3 end = start.m_82549_(look.m_82490_(maxDistance));
        AABB sweep = new AABB(start, end).m_82400_(inflateRadius);
        EntityHitResult hit = ProjectileUtil.m_150175_((Level)dragon.m_9236_(), (Entity)dragon, (Vec3)start, (Vec3)end, (AABB)sweep, e -> {
            if (!(e instanceof LivingEntity)) return false;
            LivingEntity le = (LivingEntity)e;
            if (e == dragon) return false;
            if (!e.m_6084_()) return false;
            if (!le.m_5789_()) return false;
            if (dragon.isAlly((Entity)e)) return false;
            return true;
        }, (float)((float)(maxDistance * maxDistance)));
        if (hit != null && (entity = hit.m_82443_()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            return le;
        }
        return null;
    }
}

