/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RaevyxHornGoreAbility
extends DragonAbility<Raevyx> {
    private static final float GORE_DAMAGE = 15.0f;
    private static final double GORE_RANGE = 6.5;
    private static final double GORE_RANGE_RIDDEN = 8.0;
    private static final double GORE_ANGLE_DEG = 90.0;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 3), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 2), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 3)};
    private final Set<Integer> hitIdsThisUse = new HashSet<Integer>();
    private boolean playedSoundThisUse = false;

    public RaevyxHornGoreAbility(DragonAbilityType<Raevyx, RaevyxHornGoreAbility> type, Raevyx user) {
        super(type, user, TRACK, 3);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            ((Raevyx)this.getUser()).triggerAnim("action", "horn_gore");
            this.hitIdsThisUse.clear();
            this.playedSoundThisUse = false;
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE) {
            this.hitIdsThisUse.clear();
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        if (section.sectionType != DragonAbilitySection.AbilitySectionType.ACTIVE) {
            return;
        }
        List<LivingEntity> candidates = this.findTargets();
        ArrayList<LivingEntity> newHits = new ArrayList<LivingEntity>();
        for (LivingEntity le : candidates) {
            if (!this.hitIdsThisUse.add(le.m_19879_())) continue;
            newHits.add(le);
        }
        if (!newHits.isEmpty()) {
            for (LivingEntity le : newHits) {
                this.applyGore(le);
            }
        }
    }

    private List<LivingEntity> findTargets() {
        Raevyx wyvern = (Raevyx)this.getUser();
        Vec3 head = wyvern.getHeadPosition();
        Vec3 look = wyvern.m_20154_().m_82541_();
        boolean ridden = wyvern.m_6688_() != null;
        double range = ridden ? 8.0 : 6.5;
        AABB broad = wyvern.m_20191_().m_82377_(range, range, range);
        List candidates = wyvern.m_9236_().m_6443_(LivingEntity.class, broad, e -> e != wyvern && e.m_6084_() && e.m_5789_() && !this.isAllied(wyvern, (Entity)e));
        double cosLimit = Math.cos(Math.toRadians(90.0));
        ArrayList<LivingEntity> hits = new ArrayList<LivingEntity>();
        for (LivingEntity e2 : candidates) {
            boolean angleOk;
            Vec3 toward;
            double len;
            double dist = RaevyxHornGoreAbility.distancePointToAABB(head, e2.m_20191_());
            if (dist > range + 0.4 || (len = (toward = e2.m_20191_().m_82399_().m_82546_(head)).m_82553_()) < 1.0E-4) continue;
            double dot = toward.m_82541_().m_82526_(look);
            boolean close = dist < range * 0.6;
            boolean bl = angleOk = dot >= cosLimit;
            if (ridden) {
                double bodyDist = RaevyxHornGoreAbility.distancePointToAABB(e2.m_20182_(), wyvern.m_20191_());
                boolean bl2 = angleOk = angleOk || dot >= cosLimit * 0.7 || bodyDist <= range;
            }
            if (!close && !angleOk) continue;
            hits.add(e2);
        }
        return hits;
    }

    private void applyGore(LivingEntity target) {
        Raevyx wyvern = (Raevyx)this.getUser();
        DamageSource src = wyvern.m_9236_().m_269111_().m_269333_((LivingEntity)wyvern);
        float mult = wyvern.getDamageMultiplier();
        boolean isSupercharged = wyvern.isSupercharged();
        float armorPenetration = isSupercharged ? 4.0f : 2.0f;
        float armor = (float)target.m_21133_(Attributes.f_22284_);
        float toughness = (float)target.m_21133_(Attributes.f_22285_);
        float desiredPostArmor = RaevyxHornGoreAbility.damageAfterArmor(15.0f * mult, Math.max(0.0f, armor - armorPenetration), toughness);
        float rawToDeal = RaevyxHornGoreAbility.solveRawDamageForPostArmor(desiredPostArmor, armor, toughness);
        target.m_6469_(src, rawToDeal);
        wyvern.noteAggroFrom(target);
        Vec3 look = wyvern.m_20154_().m_82541_();
        double strength = isSupercharged ? 2.8 : 1.4;
        target.m_147240_((double)((float)strength), -look.f_82479_, -look.f_82481_);
        Vec3 dv = target.m_20184_();
        float verticalLift = isSupercharged ? 0.7f : 0.35f;
        target.m_20334_(dv.f_82479_, Math.max(dv.f_82480_, (double)verticalLift), dv.f_82481_);
    }

    private static float damageAfterArmor(float damage, float armor, float toughness) {
        float f = 2.0f + toughness / 4.0f;
        float reduction = Mth.m_14036_((float)(armor - damage / f), (float)(armor * 0.2f), (float)20.0f);
        return damage * (1.0f - reduction / 25.0f);
    }

    private static float solveRawDamageForPostArmor(float desiredPostArmor, float armor, float toughness) {
        float lo = 0.0f;
        float hi = Math.max(desiredPostArmor + 16.0f, 16.0f);
        for (int i = 0; i < 8 && RaevyxHornGoreAbility.damageAfterArmor(hi, armor, toughness) < desiredPostArmor; ++i) {
            hi *= 2.0f;
        }
        for (int it = 0; it < 20; ++it) {
            float mid = (lo + hi) * 0.5f;
            float val = RaevyxHornGoreAbility.damageAfterArmor(mid, armor, toughness);
            if (val < desiredPostArmor) {
                lo = mid;
                continue;
            }
            hi = mid;
        }
        return (lo + hi) * 0.5f;
    }

    private static double distancePointToAABB(Vec3 p, AABB box) {
        double dx = Math.max(Math.max(box.f_82288_ - p.f_82479_, 0.0), p.f_82479_ - box.f_82291_);
        double dy = Math.max(Math.max(box.f_82289_ - p.f_82480_, 0.0), p.f_82480_ - box.f_82292_);
        double dz = Math.max(Math.max(box.f_82290_ - p.f_82481_, 0.0), p.f_82481_ - box.f_82293_);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private boolean isAllied(Raevyx wyvern, Entity other) {
        return wyvern.isAlly(other);
    }
}

