/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.stegonaut;

import com.leon.saintsdragons.common.item.StegonautBinderItem;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class StegonautBinderAbility {
    private static final double BUFF_RANGE = 8.0;
    private static final int BUFF_DURATION_TICKS = 40;
    private static final int BUFF_AMPLIFIER = 2;
    private static final int ABSORPTION_AMPLIFIER = 1;
    private static final Map<ResourceKey<Level>, Set<UUID>> ACTIVE_BUFF_TARGETS = new HashMap<ResourceKey<Level>, Set<UUID>>();

    private StegonautBinderAbility() {
    }

    public static void updateAllPortableBuffs(ServerLevel level) {
        HashSet<UUID> currentTargets = new HashSet<UUID>();
        for (Player player : level.m_6907_()) {
            if (!player.m_6084_() || !StegonautBinderAbility.hasBoundDrakeBinder(player)) continue;
            StegonautBinderAbility.applyPortableResistanceBuffs(level, player, currentTargets);
        }
        Set previousTargets = ACTIVE_BUFF_TARGETS.getOrDefault(level.m_46472_(), Collections.emptySet());
        if (!previousTargets.isEmpty()) {
            for (UUID uuid : previousTargets) {
                Entity entity;
                if (currentTargets.contains(uuid) || !((entity = level.m_8791_(uuid)) instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_21195_(MobEffects.f_19606_);
                livingEntity.m_21195_(MobEffects.f_19617_);
            }
        }
        ACTIVE_BUFF_TARGETS.put((ResourceKey<Level>)level.m_46472_(), currentTargets);
    }

    private static void applyPortableResistanceBuffs(ServerLevel level, Player player, Set<UUID> currentTargets) {
        StegonautBinderAbility.applyBuffsToEntity((LivingEntity)player, currentTargets);
        List nearbyEntities = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(8.0), entity -> entity != player && StegonautBinderAbility.isEligibleForPortableBuff(entity, player));
        for (LivingEntity entity2 : nearbyEntities) {
            StegonautBinderAbility.applyBuffsToEntity(entity2, currentTargets);
        }
    }

    private static boolean hasBoundDrakeBinder(Player player) {
        if (StegonautBinderAbility.findBoundDrakeBinderInList((NonNullList<ItemStack>)player.m_150109_().f_35974_)) {
            return true;
        }
        if (StegonautBinderAbility.findBoundDrakeBinderInList((NonNullList<ItemStack>)player.m_150109_().f_35976_)) {
            return true;
        }
        return StegonautBinderAbility.findBoundDrakeBinderInList((NonNullList<ItemStack>)player.m_150109_().f_35975_);
    }

    private static boolean findBoundDrakeBinderInList(NonNullList<ItemStack> stacks) {
        for (ItemStack item : stacks) {
            if (item.m_41619_() || !(item.m_41720_() instanceof StegonautBinderItem) || !StegonautBinderItem.isBound(item)) continue;
            return StegonautBinderItem.getBoundDrakeUUID(item) != null;
        }
        return false;
    }

    private static boolean isEligibleForPortableBuff(LivingEntity entity, Player player) {
        OwnableEntity ownable;
        LivingEntity owner;
        if (!entity.m_6084_()) {
            return false;
        }
        if (entity instanceof Player) {
            return true;
        }
        if (entity instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            return dragon.m_21824_() && dragon.m_21830_((LivingEntity)player);
        }
        if (entity instanceof Stegonaut) {
            Stegonaut drake = (Stegonaut)entity;
            return drake.m_21824_() && drake.allyManager.isAlly(player);
        }
        if (entity instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)entity).m_269323_()) instanceof Player) {
            Player ownerPlayer = (Player)owner;
            return ownerPlayer.m_20148_().equals(player.m_20148_());
        }
        return false;
    }

    private static void applyBuffsToEntity(LivingEntity entity, Set<UUID> currentTargets) {
        MobEffectInstance resistanceEffect = new MobEffectInstance(MobEffects.f_19606_, 40, 2, false, false, false);
        MobEffectInstance absorptionEffect = new MobEffectInstance(MobEffects.f_19617_, 40, 1, false, false, false);
        entity.m_7292_(resistanceEffect);
        entity.m_7292_(absorptionEffect);
        currentTargets.add(entity.m_20148_());
    }
}

