/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.base;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;

public class RideableDragonData {
    public static final double WALK_MIN_VELOCITY = 8.0E-4;
    public static final double RUN_MIN_VELOCITY = 0.02;
    public static final float RIDER_INPUT_THRESHOLD = 0.05f;
    public static final float RIDER_INPUT_MIN = 0.02f;
    public static final float RIDER_INPUT_DECAY = 0.8f;
    public static final float RIDER_INPUT_ZERO_THRESHOLD = 0.01f;
    public static final double RIDDEN_RUN_VELOCITY = 0.08;
    public static final double RIDDEN_WALK_VELOCITY = 0.005;

    public static <T extends Entity> EntityDataAccessor<Boolean> createFlyingAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static <T extends Entity> EntityDataAccessor<Boolean> createTakeoffAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static <T extends Entity> EntityDataAccessor<Boolean> createHoveringAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static <T extends Entity> EntityDataAccessor<Boolean> createLandingAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static <T extends Entity> EntityDataAccessor<Boolean> createRunningAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static <T extends Entity> EntityDataAccessor<Integer> createGroundMoveStateAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    public static <T extends Entity> EntityDataAccessor<Integer> createFlightModeAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    public static <T extends Entity> EntityDataAccessor<Float> createRiderForwardAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }

    public static <T extends Entity> EntityDataAccessor<Float> createRiderStrafeAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }

    public static <T extends Entity> EntityDataAccessor<Boolean> createGoingUpAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static <T extends Entity> EntityDataAccessor<Boolean> createGoingDownAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static <T extends Entity> EntityDataAccessor<Boolean> createAcceleratingAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static <T extends Entity> EntityDataAccessor<Boolean> createSleepingAccessor(Class<T> entityClass) {
        return SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public static boolean isSignificantRiderInput(float forward, float strafe) {
        return Math.abs(forward) + Math.abs(strafe) > 0.05f;
    }

    public static float applyInputThreshold(float input) {
        return Math.abs(input) > 0.02f ? input : 0.0f;
    }

    public static float decayRiderInput(float input) {
        float decayed = input * 0.8f;
        return Math.abs(decayed) < 0.01f ? 0.0f : decayed;
    }

    public static int getGroundStateFromVelocity(double velocitySqr) {
        if (velocitySqr > 0.02) {
            return 2;
        }
        if (velocitySqr > 8.0E-4) {
            return 1;
        }
        return 0;
    }

    public static int getRiddenGroundStateFromVelocity(double velocitySqr) {
        if (velocitySqr > 0.08) {
            return 2;
        }
        if (velocitySqr > 0.005) {
            return 1;
        }
        return 0;
    }

    private RideableDragonData() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

