/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.conductivity;

import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityProfile;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.interfaces.ElectricalConductivityCapable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public final class ElectricalConductivityHelper {
    private ElectricalConductivityHelper() {
    }

    public static ElectricalConductivityState evaluate(ElectricalConductivityCapable subject) {
        LivingEntity entity = subject.asConductiveEntity();
        Level level = entity.m_9236_();
        BlockPos pos = entity.m_20183_();
        boolean submerged = entity.m_20072_();
        boolean wet = entity.m_20071_() || level.m_46758_(pos) || level.m_46470_() && level.m_45527_(pos);
        ElectricalConductivityProfile profile = subject.getConductivityProfile();
        float damage = profile.baseDamageMultiplier();
        double range = profile.baseRangeMultiplier();
        if (submerged) {
            damage += profile.submergedDamageBonus();
            range += profile.submergedRangeBonus();
        } else if (wet) {
            damage += profile.wetDamageBonus();
            range += profile.wetRangeBonus();
        }
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (range < 0.0) {
            range = 0.0;
        }
        return new ElectricalConductivityState(submerged, wet, damage, range);
    }
}

