/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;

public class DragonBodyControl
extends BodyRotationControl {
    private static final int HISTORY_SIZE = 10;
    private final Mob entity;
    private float targetYawHead;
    private final double[] histPosX = new double[10];
    private final double[] histPosZ = new double[10];
    private final float turnSpeed;

    public DragonBodyControl(Mob entity) {
        this(entity, 0.6f);
    }

    public DragonBodyControl(Mob entity, float turnSpeed) {
        super(entity);
        this.entity = entity;
        this.turnSpeed = turnSpeed;
    }

    public void m_8121_() {
        double dz;
        if (this.entity.m_20160_()) {
            return;
        }
        for (int i = this.histPosX.length - 1; i > 0; --i) {
            this.histPosX[i] = this.histPosX[i - 1];
            this.histPosZ[i] = this.histPosZ[i - 1];
        }
        this.histPosX[0] = this.entity.m_20185_();
        this.histPosZ[0] = this.entity.m_20189_();
        double dx = this.delta(this.histPosX);
        double distSq = dx * dx + (dz = this.delta(this.histPosZ)) * dz;
        if (distSq > 2.5E-7) {
            boolean movingBackward;
            double moveAngle = Math.toDegrees(Mth.m_14136_((double)dz, (double)dx)) - 90.0;
            float angleDiff = Math.abs(Mth.m_14177_((float)((float)moveAngle - this.entity.f_20883_)));
            boolean bl = movingBackward = angleDiff > 135.0f;
            if (!movingBackward) {
                this.entity.f_20883_ = (float)((double)this.entity.f_20883_ + Mth.m_14175_((double)(moveAngle - (double)this.entity.f_20883_)) * (double)this.turnSpeed);
            }
            this.targetYawHead = this.entity.f_20885_;
        } else {
            this.targetYawHead = DragonBodyControl.smooth(this.targetYawHead, this.entity.f_20885_, 0.3f);
            this.entity.f_20883_ = DragonBodyControl.approach(this.targetYawHead, this.entity.f_20883_, 75.0f);
        }
    }

    private double delta(double[] arr) {
        return this.mean(arr, 0) - this.mean(arr, 5);
    }

    private double mean(double[] arr, int start) {
        double mean = 0.0;
        for (int i = 0; i < 5; ++i) {
            mean += arr[i + start];
        }
        return mean / (double)arr.length;
    }

    private static float smooth(float current, float target, float speed) {
        return current + (target - current) * speed;
    }

    private static float approach(float target, float current, float limit) {
        float delta = Mth.m_14177_((float)(current - target));
        if (delta < -limit) {
            delta = -limit;
        } else if (delta >= limit) {
            delta = limit;
        }
        return target + delta * 0.55f;
    }
}

