/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RaevyxFlightController {
    private final Raevyx wyvern;
    private BlockPos plannedLandingPos = null;
    private static final double TAKEOFF_UPWARD_FORCE = 0.11;
    private static final double LANDING_DOWNWARD_FORCE = 0.4;
    private static final double FALLING_RESISTANCE = 0.6;
    private static final int TAKEOFF_TIME_THRESHOLD = 30;
    private static final int LANDING_TIME_THRESHOLD = 40;

    public RaevyxFlightController(Raevyx wyvern) {
        this.wyvern = wyvern;
    }

    public void handleFlightLogic() {
        if (this.wyvern.m_29443_()) {
            this.handleFlyingTick();
        } else {
            this.handleGroundedTick();
        }
        if (this.wyvern.isLanding()) {
            this.handleSimpleLanding();
        }
    }

    public void switchToGroundNavigation() {
        this.wyvern.switchToGroundNavigation();
    }

    public void planSmartLanding() {
        if (this.wyvern.m_9236_().f_46443_) {
            return;
        }
        LivingEntity owner = this.wyvern.m_269323_();
        BlockPos center = owner != null && owner.m_9236_() == this.wyvern.m_9236_() && (double)this.wyvern.m_20270_((Entity)owner) < 40.0 ? owner.m_20183_() : this.wyvern.m_20183_();
        this.plannedLandingPos = this.findSafeLandingSpot(center);
        if (this.plannedLandingPos != null) {
            this.wyvern.m_21573_().m_26519_((double)this.plannedLandingPos.m_123341_() + 0.5, (double)this.plannedLandingPos.m_123342_() + 0.5, (double)this.plannedLandingPos.m_123343_() + 0.5, 1.2);
            this.wyvern.setHovering(true);
        }
    }

    private BlockPos findSafeLandingSpot(BlockPos center) {
        Level level = this.wyvern.m_9236_();
        for (int r = 2; r <= 10; r += 2) {
            for (int step = 0; step < 16; ++step) {
                double ang = Math.PI * 2 * ((double)step / 16.0);
                int x = center.m_123341_() + (int)Math.round(Math.cos(ang) * (double)r);
                int z = center.m_123343_() + (int)Math.round(Math.sin(ang) * (double)r);
                int startY = center.m_123342_() + 6;
                int minY = center.m_123342_() - 8;
                for (int y = startY; y >= minY; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockPos below = pos.m_7495_();
                    BlockState bsBelow = level.m_8055_(below);
                    BlockState bsAt = level.m_8055_(pos);
                    boolean solidBelow = !bsBelow.m_60795_() && !bsBelow.m_60812_((BlockGetter)level, below).m_83281_();
                    boolean freeAt = bsAt.m_60812_((BlockGetter)level, pos).m_83281_();
                    boolean fluidOk = bsAt.m_60819_().m_76178_();
                    if (!solidBelow || !freeAt || !fluidOk || !this.isFlatEnough(pos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private boolean isFlatEnough(BlockPos pos) {
        Level level = this.wyvern.m_9236_();
        int y = pos.m_123342_();
        int[] dx = new int[]{1, -1, 0, 0};
        int[] dz = new int[]{0, 0, 1, -1};
        for (int i = 0; i < 4; ++i) {
            BlockPos p = pos.m_7918_(dx[i], 0, dz[i]);
            int ny = this.surfaceYAt(p);
            if (Math.abs(ny - y) > 1) {
                return false;
            }
            BlockPos below = new BlockPos(p.m_123341_(), ny - 1, p.m_123343_());
            BlockState st = level.m_8055_(below);
            if (st.m_60819_().m_76178_()) continue;
            return false;
        }
        return true;
    }

    private int surfaceYAt(BlockPos pos) {
        Level level = this.wyvern.m_9236_();
        int y = pos.m_123342_();
        for (int dy = 0; dy <= 6; ++dy) {
            BlockPos p = new BlockPos(pos.m_123341_(), y - dy, pos.m_123343_());
            BlockPos below = p.m_7495_();
            BlockState bsBelow = level.m_8055_(below);
            BlockState bsAt = level.m_8055_(p);
            if (bsBelow.m_60795_() || bsBelow.m_60812_((BlockGetter)level, below).m_83281_() || !bsAt.m_60812_((BlockGetter)level, p).m_83281_()) continue;
            return p.m_123342_();
        }
        return y;
    }

    public void initiateAggressiveLanding() {
        if (!this.wyvern.m_29443_()) {
            return;
        }
        this.wyvern.setLanding(true);
        this.wyvern.setFlying(false);
        this.wyvern.setTakeoff(false);
        this.wyvern.setHovering(false);
        this.wyvern.setRunning(true);
        this.wyvern.m_21573_().m_26573_();
        this.wyvern.setHovering(true);
        this.wyvern.landingTimer = 0;
    }

    public void handleFlightTravel(Vec3 motion) {
        if (this.wyvern.isTakeoff() || this.wyvern.isHovering()) {
            this.handleHoveringTravel(motion);
        } else {
            this.handleGlidingTravel(motion);
        }
    }

    private void handleFlyingTick() {
        ++this.wyvern.timeFlying;
        if (this.wyvern.m_20184_().f_82480_ < 0.0 && this.wyvern.m_6084_()) {
            this.wyvern.m_20256_(this.wyvern.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.wyvern.m_21827_() || this.wyvern.m_20159_()) {
            this.wyvern.setTakeoff(false);
            this.wyvern.setHovering(false);
            this.wyvern.setFlying(false);
            return;
        }
        if (!this.wyvern.m_9236_().f_46443_) {
            this.handleServerFlightLogic();
            this.handleFlightPitchControl();
        }
        this.applyHoverStabilizer();
    }

    private void handleServerFlightLogic() {
        LivingEntity target;
        this.wyvern.setTakeoff(this.shouldTakeoff() && this.wyvern.m_29443_());
        if (this.wyvern.isTakeoff() && this.wyvern.m_29443_() && this.wyvern.m_6084_()) {
            if (this.wyvern.timeFlying < 30) {
                this.wyvern.m_20256_(this.wyvern.m_20184_().m_82520_(0.0, 0.11, 0.0));
            }
            if (this.wyvern.landingFlag) {
                this.wyvern.m_20256_(this.wyvern.m_20184_().m_82520_(0.0, -0.4, 0.0));
            }
        }
        if (!this.wyvern.isTakeoff() && this.wyvern.m_29443_() && this.wyvern.timeFlying > 40 && this.wyvern.m_20096_() && ((target = this.wyvern.m_5448_()) == null || !target.m_6084_() || this.wyvern.m_20160_())) {
            this.wyvern.setFlying(false);
        }
        if (this.wyvern.isLanding() && this.plannedLandingPos != null) {
            if (this.wyvern.f_19797_ % 5 == 0 && this.wyvern.m_21573_().m_26571_()) {
                this.wyvern.m_21573_().m_26519_((double)this.plannedLandingPos.m_123341_() + 0.5, (double)this.plannedLandingPos.m_123342_() + 0.5, (double)this.plannedLandingPos.m_123343_() + 0.5, 1.1);
            }
            if (this.wyvern.m_20096_()) {
                this.plannedLandingPos = null;
            }
        }
    }

    private void applyHoverStabilizer() {
        boolean hoveringLike;
        if (!this.wyvern.m_29443_()) {
            return;
        }
        if (this.wyvern.m_6688_() != null) {
            return;
        }
        boolean bl = hoveringLike = this.wyvern.isHovering() || this.wyvern.isTakeoff() || this.wyvern.isBeaming();
        if (!hoveringLike) {
            return;
        }
        Vec3 v = this.wyvern.m_20184_();
        double h = Math.sqrt(v.f_82479_ * v.f_82479_ + v.f_82481_ * v.f_82481_);
        if (h < 0.03) {
            this.wyvern.m_20334_(0.0, v.f_82480_ * 0.98, 0.0);
        } else {
            this.wyvern.m_20334_(v.f_82479_ * 0.85, v.f_82480_ * 0.98, v.f_82481_ * 0.85);
        }
    }

    private void handleGroundedTick() {
        this.wyvern.timeFlying = 0;
    }

    public boolean shouldTakeoff() {
        if (this.wyvern.m_6688_() != null) {
            return this.wyvern.getRiderTakeoffTicks() > 0;
        }
        LivingEntity target = this.wyvern.m_5448_();
        if (target != null && target.m_6084_()) {
            double d = this.wyvern.m_20270_((Entity)target);
            boolean targetFarAway = d > 20.0;
            boolean targetAbove = target.m_20186_() - this.wyvern.m_20186_() > 5.0;
            boolean cantReachOnGround = d > 10.0 && !this.wyvern.m_21574_().m_148306_((Entity)target);
            return this.wyvern.landingFlag || targetFarAway || targetAbove || cantReachOnGround;
        }
        return this.wyvern.landingFlag || this.wyvern.timeFlying < 30;
    }

    private void handleFlightPitchControl() {
        if (this.wyvern.m_6688_() != null) {
            return;
        }
        if (!this.wyvern.m_29443_() || this.wyvern.isLanding() || this.wyvern.isHovering()) {
            return;
        }
        Vec3 velocity = this.wyvern.m_20184_();
        double horizontalSpeed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
        if (horizontalSpeed > 0.05) {
            float desiredPitch = (float)(Math.atan2(-velocity.f_82480_, horizontalSpeed) * 57.2957763671875);
            desiredPitch = Mth.m_14036_((float)desiredPitch, (float)-25.0f, (float)35.0f);
            this.wyvern.m_146926_(Mth.m_14148_((float)this.wyvern.m_146909_(), (float)desiredPitch, (float)3.0f));
        }
    }

    private void handleSimpleLanding() {
        if (!this.wyvern.m_9236_().f_46443_) {
            ++this.wyvern.landingTimer;
            int landingTime = 60;
            if (this.wyvern.landingTimer > landingTime || this.wyvern.m_20096_()) {
                this.wyvern.setLanding(false);
                this.wyvern.setFlying(false);
                this.wyvern.setTakeoff(false);
                this.wyvern.setHovering(false);
                this.wyvern.markLandedNow();
                this.switchToGroundNavigation();
            }
        }
    }

    private void handleGlidingTravel(Vec3 motion) {
        Vec3 vec3 = this.wyvern.m_20184_();
        if (vec3.f_82480_ > -0.5) {
            this.wyvern.f_19789_ = 1.0f;
        }
        Vec3 moveDirection = this.wyvern.m_20154_().m_82541_();
        float pitchRad = this.wyvern.m_146909_() * ((float)Math.PI / 180);
        vec3 = this.applyGlidingPhysics(vec3, moveDirection, pitchRad);
        float horizontalFriction = 0.99f;
        float verticalFriction = 0.98f;
        this.wyvern.m_20256_(vec3.m_82542_((double)horizontalFriction, (double)verticalFriction, (double)horizontalFriction));
        this.wyvern.m_6478_(MoverType.SELF, this.wyvern.m_20184_());
    }

    private Vec3 applyGlidingPhysics(Vec3 currentVel, Vec3 moveDirection, float pitchRad) {
        double horizontalSpeed = Math.sqrt(moveDirection.f_82479_ * moveDirection.f_82479_ + moveDirection.f_82481_ * moveDirection.f_82481_);
        if (horizontalSpeed < 0.001) {
            return currentVel;
        }
        double currentHorizontalSpeed = Math.sqrt(currentVel.m_165925_());
        double lookDirectionLength = moveDirection.m_82553_();
        float pitchFactor = Mth.m_14089_((float)pitchRad);
        pitchFactor = (float)((double)pitchFactor * (double)pitchFactor * Math.min(1.0, lookDirectionLength / 0.4));
        double gravity = this.getGravity();
        Vec3 result = currentVel.m_82520_(0.0, gravity * (-1.0 + (double)pitchFactor * 0.75), 0.0);
        if (result.f_82480_ < 0.0 && horizontalSpeed > 0.0) {
            double liftFactor = this.getLiftFactor(result, pitchFactor);
            result = result.m_82520_(moveDirection.f_82479_ * liftFactor / horizontalSpeed, liftFactor, moveDirection.f_82481_ * liftFactor / horizontalSpeed);
        }
        if (pitchRad < 0.0f && horizontalSpeed > 0.0) {
            double diveFactor = currentHorizontalSpeed * (double)(-Mth.m_14031_((float)pitchRad)) * 0.04;
            result = result.m_82520_(-moveDirection.f_82479_ * diveFactor / horizontalSpeed, diveFactor * 3.2, -moveDirection.f_82481_ * diveFactor / horizontalSpeed);
        }
        if (horizontalSpeed > 0.0) {
            double alignmentFactor = 0.1;
            result = result.m_82520_((moveDirection.f_82479_ / horizontalSpeed * currentHorizontalSpeed - result.f_82479_) * alignmentFactor, 0.0, (moveDirection.f_82481_ / horizontalSpeed * currentHorizontalSpeed - result.f_82481_) * alignmentFactor);
        }
        return result;
    }

    private double getLiftFactor(Vec3 result, double pitchFactor) {
        double baseLiftFactor = result.f_82480_ * -0.1 * pitchFactor;
        double liftMultiplier = 1.0;
        if (this.wyvern.getFlappingFraction() > 0.3f) {
            liftMultiplier += (double)this.wyvern.getFlappingFraction() * 0.6;
        }
        if (this.wyvern.getGlidingFraction() > 0.5f) {
            liftMultiplier += (double)this.wyvern.getGlidingFraction() * 0.4;
        }
        return baseLiftFactor * liftMultiplier;
    }

    private double getGravity() {
        double gravity = 0.08;
        if (this.wyvern.getFlappingFraction() > 0.2f) {
            gravity *= 1.0 - (double)this.wyvern.getFlappingFraction() * 0.5;
        } else if (this.wyvern.getHoveringFraction() > 0.4f) {
            gravity *= 1.0 - (double)this.wyvern.getHoveringFraction() * 0.3;
        }
        if (this.wyvern.getGlidingFraction() > 0.5f) {
            gravity *= 1.0 - (double)this.wyvern.getGlidingFraction() * 0.2;
        }
        return gravity;
    }

    private void handleHoveringTravel(Vec3 motion) {
        double dz;
        double dy;
        double dx;
        double distanceToDest;
        BlockPos ground = new BlockPos((int)this.wyvern.m_20185_(), (int)(this.wyvern.m_20191_().f_82289_ - 1.0), (int)this.wyvern.m_20189_());
        float friction = 0.91f;
        if (this.wyvern.m_20096_()) {
            friction = this.wyvern.m_9236_().m_8055_(ground).getFriction((LevelReader)this.wyvern.m_9236_(), ground, (Entity)this.wyvern) * 0.91f;
        }
        float frictionFactor = 0.16277137f / (friction * friction * friction);
        friction = 0.91f;
        if (this.wyvern.m_20096_()) {
            friction = this.wyvern.m_9236_().m_8055_(ground).getFriction((LevelReader)this.wyvern.m_9236_(), ground, (Entity)this.wyvern) * 0.91f;
        }
        this.wyvern.m_19920_(this.wyvern.m_20096_() ? 0.1f * frictionFactor : 0.02f, motion);
        this.wyvern.m_6478_(MoverType.SELF, this.wyvern.m_20184_());
        this.wyvern.m_20256_(this.wyvern.m_20184_().m_82490_((double)friction));
        BlockPos destination = this.wyvern.m_21573_().m_26567_();
        if (destination != null && (distanceToDest = Math.sqrt((dx = (double)destination.m_123341_() - this.wyvern.m_20185_()) * dx + (dy = (double)destination.m_123342_() - this.wyvern.m_20186_()) * dy + (dz = (double)destination.m_123343_() - this.wyvern.m_20189_()) * dz)) < 0.1) {
            this.wyvern.m_20334_(0.0, 0.0, 0.0);
        }
    }
}

