/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.cindervane.handlers;

import com.leon.saintsdragons.SaintsDragons;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CindervaneInteractionHandler {
    private final Cindervane dragon;

    public CindervaneInteractionHandler(Cindervane dragon) {
        this.dragon = dragon;
    }

    public InteractionResult handleInteraction(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!this.dragon.m_21824_()) {
            return this.handleUntamedInteraction(player, hand, heldItem);
        }
        return this.handleTamedInteraction(player, hand, heldItem);
    }

    private InteractionResult handleUntamedInteraction(Player player, InteractionHand hand, ItemStack heldItem) {
        if (!this.dragon.m_6898_(heldItem)) {
            return InteractionResult.PASS;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            this.dragon.triggerAnim("actions", "eat");
            if (this.dragon.m_217043_().m_188503_(5) == 0) {
                this.dragon.m_21828_(player);
                this.dragon.m_21573_().m_26573_();
                this.dragon.m_21839_(true);
                this.dragon.setCommand(1);
                this.dragon.m_6710_(null);
                this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)7);
                this.triggerTamingAdvancement(player);
            } else {
                this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)6);
            }
            return InteractionResult.m_19078_((boolean)false);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleTamedInteraction(Player player, InteractionHand hand, ItemStack heldItem) {
        boolean isOwner = this.dragon.m_21830_((LivingEntity)player);
        if (isOwner) {
            if (this.dragon.m_6898_(heldItem) && this.dragon.m_21223_() < this.dragon.m_21233_()) {
                return this.handleFeeding(player, heldItem);
            }
            if (this.dragon.canOwnerCommand(player) && heldItem.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                return this.handleCommandCycling(player);
            }
        }
        if (hand == InteractionHand.MAIN_HAND && heldItem.m_41619_() && !player.m_6047_()) {
            return this.handleMounting(player, isOwner);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleMounting(Player player, boolean isOwner) {
        List passengers = this.dragon.m_20197_();
        if (isOwner) {
            if (passengers.isEmpty() && this.dragon.canOwnerMount(player)) {
                if (!this.dragon.m_9236_().f_46443_) {
                    this.dragon.prepareForMounting();
                    player.m_20329_((Entity)this.dragon);
                }
                return InteractionResult.m_19078_((boolean)this.dragon.m_9236_().f_46443_);
            }
            if (!passengers.isEmpty() && passengers.get(0) != player) {
                if (!this.dragon.m_9236_().f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"entity.saintsdragons.cindervane.mount_occupied"), true);
                }
                return InteractionResult.FAIL;
            }
        } else {
            Player firstPlayer;
            if (passengers.isEmpty()) {
                if (!this.dragon.m_9236_().f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"entity.saintsdragons.cindervane.passenger_needs_owner"), true);
                }
                return InteractionResult.FAIL;
            }
            if (passengers.size() >= 2) {
                if (!this.dragon.m_9236_().f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"entity.saintsdragons.cindervane.seats_full"), true);
                }
                return InteractionResult.FAIL;
            }
            Object e = passengers.get(0);
            if (e instanceof Player && this.dragon.m_21830_((LivingEntity)(firstPlayer = (Player)e))) {
                if (!this.dragon.m_9236_().f_46443_) {
                    player.m_20329_((Entity)this.dragon);
                }
                return InteractionResult.m_19078_((boolean)this.dragon.m_9236_().f_46443_);
            }
            if (!this.dragon.m_9236_().f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"entity.saintsdragons.cindervane.passenger_needs_owner"), true);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleFeeding(Player player, ItemStack food) {
        if (!this.dragon.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                food.m_41774_(1);
            }
            this.dragon.triggerAnim("actions", "eat");
            float healAmount = 5.0f;
            float newHealth = Math.min(this.dragon.m_21223_() + healAmount, this.dragon.m_21233_());
            boolean fullyHealed = newHealth >= this.dragon.m_21233_();
            this.dragon.m_5634_(healAmount);
            this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)7);
            if (fullyHealed) {
                player.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.cindervane.fed", (Object[])new Object[]{this.dragon.m_7755_()}), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.cindervane.fed_partial", (Object[])new Object[]{this.dragon.m_7755_()}), true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    private InteractionResult handleCommandCycling(Player player) {
        int currentCommand = this.dragon.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.dragon.setCommand(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.dragon.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.dragon.m_7755_()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.dragon.m_21839_(false);
                break;
            }
            case 1: {
                this.dragon.m_21839_(true);
                break;
            }
            case 2: {
                this.dragon.m_21839_(false);
            }
        }
    }

    private void triggerTamingAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(SaintsDragons.rl("tame_cindervane"));
            if (advancement != null) {
                serverPlayer.m_8960_().m_135988_(advancement, "tame_cindervane");
            }
        }
    }
}

