/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers;

import com.leon.saintsdragons.SaintsDragons;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record NulljawInteractionHandler(Nulljaw drake) {
    public InteractionResult handleInteraction(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!this.drake.m_21824_()) {
            return this.handleUntamedInteraction(player, hand, heldItem);
        }
        return this.handleTamedInteraction(player, hand, heldItem);
    }

    private InteractionResult handleTamedInteraction(Player player, InteractionHand hand, ItemStack heldItem) {
        if (!this.drake.m_21830_((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (this.drake.m_6898_(heldItem) && this.drake.m_21223_() < this.drake.m_21233_()) {
            return this.handleFeeding(player, heldItem);
        }
        if (this.drake.canOwnerCommand(player) && heldItem.m_41619_() && hand == InteractionHand.MAIN_HAND) {
            return this.handleCommandCycling(player);
        }
        if (hand == InteractionHand.MAIN_HAND && heldItem.m_41619_() && !player.m_6047_() && this.drake.canOwnerMount(player) && !this.drake.m_20160_()) {
            if (!this.drake.m_9236_().f_46443_) {
                if (this.drake.m_21827_()) {
                    this.drake.m_21839_(false);
                }
                this.drake.m_6710_(null);
                player.m_20329_((Entity)this.drake);
            }
            return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleFeeding(Player player, ItemStack food) {
        if (!this.drake.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                food.m_41774_(1);
            }
            this.drake.triggerAnim("action", "eat");
            float healAmount = 5.0f;
            float newHealth = Math.min(this.drake.m_21223_() + healAmount, this.drake.m_21233_());
            boolean fullyHealed = newHealth >= this.drake.m_21233_();
            this.drake.m_5634_(healAmount);
            this.drake.m_9236_().m_7605_((Entity)this.drake, (byte)7);
            if (fullyHealed) {
                player.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.nulljaw.fed", (Object[])new Object[]{this.drake.m_7755_()}), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"entity.saintsdragons.nulljaw.fed_partial", (Object[])new Object[]{this.drake.m_7755_()}), true);
            }
        }
        return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
    }

    private InteractionResult handleUntamedInteraction(Player player, InteractionHand hand, ItemStack itemstack) {
        if (!this.drake.m_6898_(itemstack)) {
            return InteractionResult.PASS;
        }
        if (!this.drake.m_9236_().f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.drake.triggerAnim("action", "eat");
            if (this.drake.m_217043_().m_188503_(8) == 0) {
                this.drake.m_21828_(player);
                this.drake.m_21839_(true);
                this.drake.setCommand(1);
                this.drake.m_9236_().m_7605_((Entity)this.drake, (byte)7);
                this.triggerTamingAdvancement(player);
            } else {
                this.drake.m_9236_().m_7605_((Entity)this.drake, (byte)6);
            }
        }
        return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
    }

    private InteractionResult handleTamedInteraction(Player player, ItemStack itemstack, InteractionHand hand) {
        if (this.drake.m_6898_(itemstack) && this.drake.m_21223_() < this.drake.m_21233_()) {
            if (!this.drake.m_9236_().f_46443_) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                float healAmount = 10.0f;
                float oldHealth = this.drake.m_21223_();
                float newHealth = Math.min(oldHealth + healAmount, this.drake.m_21233_());
                this.drake.m_21153_(newHealth);
                this.drake.m_9236_().m_7605_((Entity)this.drake, (byte)7);
            }
            return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
        }
        if (hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_() && !player.m_6144_()) {
            return this.handleMounting(player);
        }
        return this.drake.superMobInteract(player, hand);
    }

    private InteractionResult handleMounting(Player player) {
        if (!this.canPlayerMount(player) || this.drake.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!this.drake.m_9236_().f_46443_) {
            if (this.drake.m_21827_()) {
                this.drake.m_21839_(false);
            }
            this.drake.m_6710_(null);
            this.drake.m_21573_().m_26573_();
            player.m_20329_((Entity)this.drake);
        }
        return InteractionResult.m_19078_((boolean)this.drake.m_9236_().f_46443_);
    }

    private InteractionResult handleCommandCycling(Player player) {
        int currentCommand = this.drake.getCommand();
        int nextCommand = (currentCommand + 1) % 3;
        this.drake.setCommand(nextCommand);
        this.applyCommandState(nextCommand);
        if (!this.drake.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)("entity.saintsdragons.all.command_" + nextCommand), (Object[])new Object[]{this.drake.m_7755_()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private void applyCommandState(int command) {
        switch (command) {
            case 0: {
                this.drake.m_21839_(false);
                break;
            }
            case 1: {
                this.drake.m_21839_(true);
                break;
            }
            case 2: {
                this.drake.m_21839_(false);
            }
        }
    }

    private boolean canPlayerMount(Player player) {
        return this.drake.m_21824_() && this.drake.m_21830_((LivingEntity)player);
    }

    private void triggerTamingAdvancement(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(SaintsDragons.rl("tame_nulljaw"));
            if (advancement != null) {
                serverPlayer.m_8960_().m_135988_(advancement, "tame_nulljaw");
            }
        }
    }
}

