/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public final class NulljawSoundProfile
implements DragonSoundProfile {
    public static final NulljawSoundProfile INSTANCE = new NulljawSoundProfile();

    private NulljawSoundProfile() {
    }

    @Override
    public boolean handleAnimationSound(DragonSoundHandler handler, DragonEntity dragon, String key, String locator) {
        return switch (key) {
            case "nulljaw_grumble1" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_GRUMBLE_1.get(), 1.5f, 0.95f, 0.1f);
                yield true;
            }
            case "nulljaw_grumble2" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_GRUMBLE_2.get(), 1.5f, 0.95f, 0.1f);
                yield true;
            }
            case "nulljaw_grumble3" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_GRUMBLE_3.get(), 1.5f, 0.95f, 0.1f);
                yield true;
            }
            case "nulljaw_phase2" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_PHASE2.get(), 2.5f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_phase1" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_PHASE1.get(), 1.4f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_step" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_STEP.get(), 0.8f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_claw" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_CLAW.get(), 1.2f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_bite" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_BITE.get(), 1.1f, 0.95f, 0.1f);
                yield true;
            }
            case "nulljaw_roarclaw" -> {
                this.playClientSound(dragon, (SoundEvent)ModSounds.NULLJAW_ROARCLAW.get(), 1.3f, 0.9f, 0.2f);
                yield true;
            }
            case "nulljaw_roar" -> false;
            default -> false;
        };
    }

    private void playClientSound(DragonEntity dragon, SoundEvent sound, float volume, float basePitch, float variance) {
        float pitch = basePitch + dragon.m_217043_().m_188501_() * variance;
        dragon.m_9236_().m_7785_(dragon.m_20185_(), dragon.m_20186_(), dragon.m_20189_(), sound, SoundSource.NEUTRAL, volume, pitch, false);
    }
}

