/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.input;

import com.leon.saintsdragons.client.DragonStatusUIManager;
import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.network.MessageDragonRideInput;
import com.leon.saintsdragons.common.network.NetworkHandler;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;

public final class DragonRideInputHandler {
    private static final String KEY_CATEGORY = "key.categories.saintsdragons";
    public static final class_304 DRAGON_ASCEND = new class_304("key.saintsdragons.ascend", class_3675.class_307.field_1668, 32, "key.categories.saintsdragons");
    public static final class_304 DRAGON_DESCEND = new class_304("key.saintsdragons.descend", class_3675.class_307.field_1668, 342, "key.categories.saintsdragons");
    public static final class_304 DRAGON_ACCELERATE = new class_304("key.saintsdragons.accelerate", class_3675.class_307.field_1668, 341, "key.categories.saintsdragons");
    public static final class_304 DRAGON_TERTIARY_ABILITY = new class_304("key.saintsdragons.ability_tertiary", class_3675.class_307.field_1668, 71, "key.categories.saintsdragons");
    public static final class_304 DRAGON_PRIMARY_ABILITY = new class_304("key.saintsdragons.ability_primary", class_3675.class_307.field_1668, 82, "key.categories.saintsdragons");
    public static final class_304 DRAGON_SECONDARY_ABILITY = new class_304("key.saintsdragons.ability_secondary", class_3675.class_307.field_1668, 72, "key.categories.saintsdragons");
    public static final class_304 DRAGON_TOGGLE_MELEE = new class_304("key.saintsdragons.toggle_melee", class_3675.class_307.field_1668, 88, "key.categories.saintsdragons");
    private static final class_304[] ALL_KEYS = new class_304[]{DRAGON_ASCEND, DRAGON_DESCEND, DRAGON_ACCELERATE, DRAGON_TERTIARY_ABILITY, DRAGON_PRIMARY_ABILITY, DRAGON_SECONDARY_ABILITY, DRAGON_TOGGLE_MELEE};
    private static boolean wasAscendPressed = false;
    private static boolean wasAccelerateDown = false;
    private static boolean wasTertiaryAbilityDown = false;
    private static boolean wasPrimaryAbilityDown = false;
    private static boolean wasSecondaryAbilityDown = false;
    private static boolean wasAttackDown = false;
    private static boolean wasToggleMeleeDown = false;
    private static int meleeCooldownTicks = 0;
    private static float lastForward = 0.0f;
    private static float lastStrafe = 0.0f;
    private static float lastYaw = 0.0f;
    private static boolean lastAscendDown = false;
    private static boolean lastDescendDown = false;

    private DragonRideInputHandler() {
    }

    public static void registerKeys(Consumer<class_304> registrar) {
        for (class_304 mapping : ALL_KEYS) {
            registrar.accept(mapping);
        }
        class_304.method_1426();
    }

    public static void clientTick() {
        RideableDragonBase dragon;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            DragonRideInputHandler.resetStateTracking();
            return;
        }
        class_1297 vehicle = player.method_5854();
        if (!(vehicle instanceof RideableDragonBase) || !(dragon = (RideableDragonBase)vehicle).canBeControlledBy((class_1657)player)) {
            DragonRideInputHandler.resetStateTracking();
            return;
        }
        DragonRideInputHandler.handleControls(mc, player, dragon);
    }

    private static void handleControls(class_310 mc, class_746 player, RideableDragonBase dragon) {
        boolean movementChanged;
        if (meleeCooldownTicks > 0) {
            --meleeCooldownTicks;
        }
        boolean ascendDown = DRAGON_ASCEND.method_1434() || mc.field_1690.field_1903.method_1434();
        boolean descendDown = DRAGON_DESCEND.method_1434() || mc.field_1690.field_1832.method_1434();
        boolean accelerateDown = DRAGON_ACCELERATE.method_1434() || mc.field_1690.field_1867.method_1434();
        boolean tertiaryDown = DRAGON_TERTIARY_ABILITY.method_1434();
        boolean primaryDown = DRAGON_PRIMARY_ABILITY.method_1434();
        boolean secondaryDown = DRAGON_SECONDARY_ABILITY.method_1434();
        boolean toggleMeleeDown = DRAGON_TOGGLE_MELEE.method_1434();
        boolean attackDown = mc.field_1690.field_1886.method_1434();
        float forward = player.field_6250;
        float strafe = player.field_6212;
        float yaw = player.method_36454();
        boolean bl = movementChanged = forward != lastForward || strafe != lastStrafe || Math.abs(yaw - lastYaw) > 0.1f || ascendDown != lastAscendDown || descendDown != lastDescendDown;
        if (movementChanged) {
            DragonRideInputHandler.sendInput(ascendDown, descendDown, DragonRiderAction.NONE, null, forward, strafe, yaw);
            lastForward = forward;
            lastStrafe = strafe;
            lastYaw = yaw;
            lastAscendDown = ascendDown;
            lastDescendDown = descendDown;
        }
        if (accelerateDown != wasAccelerateDown) {
            DragonRiderAction action = accelerateDown ? DragonRiderAction.ACCELERATE : DragonRiderAction.STOP_ACCELERATE;
            DragonRideInputHandler.sendInput(ascendDown, descendDown, action, null, forward, strafe, yaw);
        }
        if (ascendDown && !wasAscendPressed && !dragon.method_6581()) {
            DragonRideInputHandler.sendInput(false, false, DragonRiderAction.TAKEOFF_REQUEST, null, forward, strafe, yaw);
        }
        if (toggleMeleeDown && !wasToggleMeleeDown && meleeCooldownTicks == 0) {
            if (dragon.hasSecondaryMelee()) {
                DragonRideInputHandler.sendInput(false, false, DragonRiderAction.TOGGLE_MELEE, null, forward, strafe, yaw);
                meleeCooldownTicks = 60;
                int newMode = (dragon.getMeleeMode() + 1) % 2;
                DragonStatusUIManager.getInstance().getDragonStatusUI().getMeleeModeNotification().showNotification(newMode);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"saintsdragons.message.no_secondary_melee"), true);
            }
        }
        DragonRideInputHandler.handleAbilityBinding(dragon.getTertiaryRiderAbility(), tertiaryDown, wasTertiaryAbilityDown, forward, strafe, yaw);
        DragonRideInputHandler.handleAbilityBinding(dragon.getPrimaryRiderAbility(), primaryDown, wasPrimaryAbilityDown, forward, strafe, yaw);
        DragonRideInputHandler.handleAbilityBinding(dragon.getSecondaryRiderAbility(), secondaryDown, wasSecondaryAbilityDown, forward, strafe, yaw);
        DragonRideInputHandler.handleAbilityBinding(dragon.getAttackRiderAbility(), attackDown, wasAttackDown, forward, strafe, yaw);
        wasAscendPressed = ascendDown;
        wasAccelerateDown = accelerateDown;
        wasTertiaryAbilityDown = tertiaryDown;
        wasPrimaryAbilityDown = primaryDown;
        wasSecondaryAbilityDown = secondaryDown;
        wasAttackDown = attackDown;
        wasToggleMeleeDown = toggleMeleeDown;
    }

    private static void handleAbilityBinding(RideableDragonBase.RiderAbilityBinding binding, boolean currentDown, boolean previousDown, float forward, float strafe, float yaw) {
        if (binding == null) {
            return;
        }
        String abilityId = binding.abilityId();
        if (abilityId == null || abilityId.isEmpty()) {
            return;
        }
        RideableDragonBase.RiderAbilityBinding.Activation activation = binding.activation();
        if (activation == RideableDragonBase.RiderAbilityBinding.Activation.PRESS) {
            if (currentDown && !previousDown) {
                DragonRideInputHandler.sendInput(false, false, DragonRiderAction.ABILITY_USE, abilityId, forward, strafe, yaw);
            }
        } else if (activation == RideableDragonBase.RiderAbilityBinding.Activation.HOLD) {
            if (currentDown && !previousDown) {
                DragonRideInputHandler.sendInput(false, false, DragonRiderAction.ABILITY_USE, abilityId, forward, strafe, yaw);
            } else if (!currentDown && previousDown) {
                DragonRideInputHandler.sendInput(false, false, DragonRiderAction.ABILITY_STOP, abilityId, forward, strafe, yaw);
            }
        }
    }

    private static void sendInput(boolean goingUp, boolean goingDown, DragonRiderAction action, String abilityName, float forward, float strafe, float yaw) {
        NetworkHandler.sendToServer(new MessageDragonRideInput(goingUp, goingDown, action, abilityName, forward, strafe, yaw));
    }

    private static void resetStateTracking() {
        wasAscendPressed = false;
        wasAccelerateDown = false;
        wasTertiaryAbilityDown = false;
        wasPrimaryAbilityDown = false;
        wasSecondaryAbilityDown = false;
        wasAttackDown = false;
        wasToggleMeleeDown = false;
        meleeCooldownTicks = 0;
        lastForward = 0.0f;
        lastStrafe = 0.0f;
        lastYaw = 0.0f;
        lastAscendDown = false;
        lastDescendDown = false;
    }
}

