/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.cindervane;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class CindervaneModel
extends DefaultedEntityGeoModel<Cindervane> {
    private static final class_2960 MODEL = SaintsDragonsCommon.rl("geo/entity/cindervane.geo.json");
    private static final class_2960 ANIM = SaintsDragonsCommon.rl("animations/entity/cindervane.animation.json");
    private static final class_2960 MALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/cindervane/cindervane.png");
    private static final class_2960 FEMALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/cindervane/cindervane_female.png");

    public CindervaneModel() {
        super(SaintsDragonsCommon.rl("cindervane"), "head");
    }

    public void setCustomAnimations(Cindervane entity, long instanceId, AnimationState<Cindervane> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        float partialTick = animationState.getPartialTick();
        if (entity.method_5805()) {
            this.applyBodyRotationDeviation(entity, partialTick);
            this.applyBankingRoll(entity, animationState);
            this.applyNeckFollow();
            this.applyTailDrag(entity, partialTick);
        }
    }

    public class_2960 getModelResource(Cindervane entity) {
        return MODEL;
    }

    public class_2960 getTextureResource(Cindervane entity) {
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public class_2960 getAnimationResource(Cindervane entity) {
        return ANIM;
    }

    private void applyBodyRotationDeviation(Cindervane entity, float partialTick) {
        Optional rootOpt = this.getBone("body");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyBankingRoll(Cindervane entity, AnimationState<Cindervane> state) {
        Optional bodyOpt = this.getBone("body");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        BoneSnapshot snap = body.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float bankAngleRad = class_3532.method_15363((float)(-bankAngleDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(snap.getRotZ() + bankAngleRad);
    }

    private void applyNeckFollow() {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        BoneSnapshot snapshot = head.getInitialSnapshot();
        float headDeltaX = head.getRotX() - snapshot.getRotX();
        float headDeltaY = head.getRotY() - snapshot.getRotY();
        headDeltaX = class_3532.method_15363((float)headDeltaX, (float)-0.35f, (float)0.35f);
        headDeltaY = class_3532.method_15363((float)headDeltaY, (float)-0.45f, (float)0.45f);
        head.setRotX(snapshot.getRotX());
        head.setRotY(snapshot.getRotY());
        this.applyNeckBoneFollow("neck1LookControl", headDeltaX, headDeltaY, 0.4f);
        this.applyNeckBoneFollow("neck2LookControl", headDeltaX, headDeltaY, 0.6f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        BoneSnapshot snapshot = bone.getInitialSnapshot();
        bone.setRotX(snapshot.getRotX() + headDeltaX * weight);
        bone.setRotY(snapshot.getRotY() + headDeltaY * weight);
    }

    private void applyTailDrag(Cindervane entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = class_3532.method_15350((double)velocity, (double)-30.0, (double)30.0);
        float targetVelocity = (float)velocity;
        float smoothedVelocity = entity.smoothTailDragVelocity(targetVelocity);
        float velocityRad = smoothedVelocity * ((float)Math.PI / 180);
        this.applyTailBoneRotation("tail1", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail2", velocityRad * 2.5f);
        this.applyTailBoneRotation("tail3", velocityRad * 3.0f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }
}

