/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class RaevyxModel
extends DefaultedEntityGeoModel<Raevyx> {
    private static final class_2960 ADULT_MODEL = SaintsDragonsCommon.rl("geo/entity/raevyx.geo.json");
    private static final class_2960 FEMALE_MODEL = SaintsDragonsCommon.rl("geo/entity/raevyx.geo.json");
    private static final class_2960 BABY_MODEL = SaintsDragonsCommon.rl("geo/entity/baby_raevyx.geo.json");
    private static final class_2960 ADULT_ANIM = SaintsDragonsCommon.rl("animations/entity/raevyx.animation.json");
    private static final class_2960 BABY_ANIM = SaintsDragonsCommon.rl("animations/entity/baby_raevyx.animation.json");
    private static final class_2960 MALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/raevyx/raevyx.png");
    private static final class_2960 FEMALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/raevyx/raevyx_female.png");
    private static final class_2960 BABY_TEXTURE = SaintsDragonsCommon.rl("textures/entity/raevyx/baby_raevyx.png");

    public RaevyxModel() {
        super(SaintsDragonsCommon.rl("raevyx"), "head");
    }

    public class_2960 getModelResource(Raevyx entity) {
        if (entity.method_6109()) {
            return BABY_MODEL;
        }
        if (entity.isFemale()) {
            return FEMALE_MODEL;
        }
        return ADULT_MODEL;
    }

    public class_2960 getTextureResource(Raevyx entity) {
        if (entity.method_6109()) {
            return BABY_TEXTURE;
        }
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public class_2960 getAnimationResource(Raevyx entity) {
        return entity.method_6109() ? BABY_ANIM : ADULT_ANIM;
    }

    public void setCustomAnimations(Raevyx entity, long instanceId, AnimationState<Raevyx> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        float partialTick = animationState.getPartialTick();
        if (entity.method_5805()) {
            this.applyBodyRotationDeviation(entity, partialTick);
            this.applyBankingRoll(entity, animationState);
            this.applyNeckFollow(entity, animationState);
            this.applyTailDrag(entity, partialTick);
        }
    }

    private void applyBodyRotationDeviation(Raevyx entity, float partialTick) {
        Optional rootOpt = this.getBone("body");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyBankingRoll(Raevyx entity, AnimationState<Raevyx> state) {
        Optional bodyOpt = this.getBone("body");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        BoneSnapshot snap = body.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float bankAngleRad = class_3532.method_15363((float)(-bankAngleDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(snap.getRotZ() + bankAngleRad);
    }

    private void applyNeckFollow(Raevyx entity, AnimationState<Raevyx> state) {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        float headDeltaX = head.getRotX() - head.getInitialSnapshot().getRotX();
        float headDeltaY = head.getRotY() - head.getInitialSnapshot().getRotY();
        head.setRotX(head.getInitialSnapshot().getRotX());
        head.setRotY(head.getInitialSnapshot().getRotY());
        this.applyNeckBoneFollow("neck1LookControl", headDeltaX, headDeltaY, 0.2f);
        this.applyNeckBoneFollow("neck2LookControl", headDeltaX, headDeltaY, 0.25f);
        this.applyNeckBoneFollow("neck3LookControl", headDeltaX, headDeltaY, 0.3f);
        this.applyNeckBoneFollow("neck4LookControl", headDeltaX, headDeltaY, 0.35f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        BoneSnapshot snap = bone.getInitialSnapshot();
        float addX = headDeltaX * weight;
        float addY = headDeltaY * weight;
        bone.setRotX(snap.getRotX() + addX);
        bone.setRotY(snap.getRotY() + addY);
    }

    private void applyTailDrag(Raevyx entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = class_3532.method_15350((double)velocity, (double)-30.0, (double)30.0);
        float targetVelocity = (float)velocity;
        float smoothedVelocity = entity.smoothTailDragVelocity(targetVelocity);
        float velocityRad = smoothedVelocity * ((float)Math.PI / 180);
        this.applyTailBoneRotation("tail1Controller", velocityRad * 0.5f);
        this.applyTailBoneRotation("tail2Controller", velocityRad * 0.75f);
        this.applyTailBoneRotation("tail3Controller", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail4Controller", velocityRad * 1.25f);
        this.applyTailBoneRotation("tail5Controller", velocityRad * 1.75f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }
}

