/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.stegonaut;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class StegonautModel
extends DefaultedEntityGeoModel<Stegonaut> {
    private static final class_2960 MODEL = SaintsDragonsCommon.rl("geo/entity/stegonaut.geo.json");
    private static final class_2960 ANIM = SaintsDragonsCommon.rl("animations/entity/stegonaut.animation.json");
    private static final class_2960 MALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/stegonaut/stegonaut.png");
    private static final class_2960 FEMALE_TEXTURE = SaintsDragonsCommon.rl("textures/entity/stegonaut/stegonaut_female.png");

    public StegonautModel() {
        super(SaintsDragonsCommon.rl("stegonaut"), "head");
    }

    public class_2960 getModelResource(Stegonaut entity) {
        return MODEL;
    }

    public class_2960 getTextureResource(Stegonaut entity) {
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public class_2960 getAnimationResource(Stegonaut entity) {
        return ANIM;
    }

    public void setCustomAnimations(Stegonaut entity, long instanceId, AnimationState<Stegonaut> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        float partialTick = animationState.getPartialTick();
        this.applyBodyRotationDeviation(entity, partialTick);
        this.applyTailDrag(entity, partialTick);
    }

    private void applyBodyRotationDeviation(Stegonaut entity, float partialTick) {
        Optional rootOpt = this.getBone("root");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyTailDrag(Stegonaut entity, float partialTick) {
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = class_3532.method_15350((double)velocity, (double)-30.0, (double)30.0);
        float velocityRad = (float)(velocity * 0.01745329238474369);
        this.applyTailBoneRotation("tail1", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail2", velocityRad * 2.5f);
        this.applyTailBoneRotation("tail3", velocityRad * 3.0f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }
}

