/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.layer.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class RaevyxLightningBeamLayer
extends GeoRenderLayer<Raevyx> {
    private static final class_2960 INNER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/lightning_beam_inner.png");
    private static final class_2960 OUTER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/lightning_beam_outer.png");
    private static final class_2960 FEMALE_INNER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/female_lightning_beam_inner.png");
    private static final class_2960 FEMALE_OUTER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/female_lightning_beam_outer.png");
    private static final float BASE_BEAM_WIDTH = 0.3f;
    private static final float OUTER_BEAM_BONUS = 0.15f;
    private static final float INNER_SPEED_MULTIPLIER = 0.25f;
    private static final float OUTER_SPEED_MULTIPLIER = 0.25f;
    private static final float BEAM_SHAKE_INTENSITY = 0.01f;
    private static final Map<Raevyx, BeamState> STATES = new WeakHashMap<Raevyx, BeamState>();
    private static final float APPEAR_TICKS = 5.0f;
    private static final float DISAPPEAR_TICKS = 6.0f;
    private static final float LOCAL_OFFSET_LEFT = 1.5f;
    private static final float LOCAL_OFFSET_UP = 1.5f;
    private static final float LOCAL_OFFSET_FWD = 4.0f;

    public RaevyxLightningBeamLayer() {
        super(null);
    }

    public void render(@NotNull class_4587 poseStack, Raevyx animatable, BakedGeoModel bakedModel, @NotNull class_1921 renderType, @NotNull class_4597 bufferSource, @NotNull class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        class_243 end;
        class_243 mouthWorld;
        BeamState state = STATES.computeIfAbsent(animatable, k -> new BeamState());
        boolean beaming = animatable.isBeaming();
        if (beaming) {
            state.disappear = 0.0f;
            state.appear = class_3532.method_15363((float)(state.appear + 0.2f), (float)0.0f, (float)1.0f);
            mouthWorld = animatable.computeHeadMouthOrigin(partialTick);
            class_243 predictedEnd = RaevyxLightningBeamLayer.predictBeamEnd(animatable, mouthWorld, partialTick);
            class_243 serverEnd = animatable.getClientBeamEndPosition(partialTick);
            if (serverEnd == null) {
                end = predictedEnd;
            } else {
                double hspeed = animatable.method_18798().method_37267();
                float turnRate = Math.abs(class_3532.method_15381((float)animatable.field_6259, (float)animatable.field_6241));
                float weight = class_3532.method_15363((float)((float)(hspeed * 3.0 + (double)(turnRate / 90.0f))), (float)0.0f, (float)1.0f);
                end = RaevyxLightningBeamLayer.lerpVec(serverEnd, predictedEnd, weight);
            }
            state.lastMouth = mouthWorld;
            state.lastEnd = end;
        } else {
            if (state.lastMouth == null || state.lastEnd == null || state.appear <= 0.0f && state.disappear >= 1.0f) {
                return;
            }
            state.disappear = class_3532.method_15363((float)(state.disappear + 0.16666667f), (float)0.0f, (float)1.0f);
            state.appear = 0.0f;
            mouthWorld = state.lastMouth;
            end = state.lastEnd;
        }
        double ox = class_3532.method_16436((double)partialTick, (double)animatable.field_6014, (double)animatable.method_23317());
        double oy = class_3532.method_16436((double)partialTick, (double)animatable.field_6036, (double)animatable.method_23318());
        double oz = class_3532.method_16436((double)partialTick, (double)animatable.field_5969, (double)animatable.method_23321());
        float scale = 1.0f;
        class_243 rawBeamPosition = end.method_1020(mouthWorld);
        float length = (float)(rawBeamPosition.method_1033() / (double)scale);
        if (length <= 0.001f) {
            return;
        }
        class_243 vec3 = rawBeamPosition.method_1029();
        float xRot = (float)Math.acos(vec3.field_1351);
        float yRot = (float)Math.atan2(vec3.field_1350, vec3.field_1352);
        float ageInTicks = (float)animatable.field_6012 + partialTick;
        float shakeByX = (float)Math.sin(ageInTicks * 4.0f) * 0.01f;
        float shakeByY = (float)Math.sin(ageInTicks * 4.0f + 1.2f) * 0.01f;
        float shakeByZ = (float)Math.sin(ageInTicks * 4.0f + 2.4f) * 0.01f;
        float mx = (float)((mouthWorld.field_1352 - ox) / (double)scale);
        float my = (float)((mouthWorld.field_1351 - oy) / (double)scale);
        float mz = (float)((mouthWorld.field_1350 - oz) / (double)scale);
        poseStack.method_22903();
        poseStack.method_46416(mx + shakeByX, my + shakeByY, mz + shakeByZ);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((1.5707964f - yRot) * 57.295776f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees((-1.5707964f + xRot) * 57.295776f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(45.0f));
        poseStack.method_46416(1.5f, 1.5f, 4.0f);
        float visScale = beaming ? RaevyxLightningBeamLayer.easeOutCubic(state.appear) : 1.0f - state.disappear;
        visScale = class_3532.method_15363((float)visScale, (float)0.0f, (float)1.0f);
        float scaledLength = Math.max(0.001f, length * visScale);
        float scaledWidth = Math.max(0.001f, 0.3f * (0.75f + 0.25f * visScale));
        class_2960 innerTex = animatable.isFemale() ? FEMALE_INNER_TEX : INNER_TEX;
        class_2960 outerTex = animatable.isFemale() ? FEMALE_OUTER_TEX : OUTER_TEX;
        this.renderBeam(animatable, poseStack, bufferSource, partialTick, scaledWidth, scaledLength, true, innerTex);
        this.renderBeam(animatable, poseStack, bufferSource, partialTick, scaledWidth, scaledLength, false, outerTex);
        poseStack.method_22909();
    }

    private void renderBeam(Raevyx entity, class_4587 poseStack, class_4597 source, float partialTicks, float width, float length, boolean inner, class_2960 texture) {
        float speed;
        class_4588 vertexconsumer;
        int vertices;
        poseStack.method_22903();
        float startAlpha = 1.0f;
        float endAlpha = 1.0f;
        if (inner) {
            vertices = 4;
            vertexconsumer = source.getBuffer(class_1921.method_23580((class_2960)texture));
            speed = 0.25f;
        } else {
            vertices = 8;
            vertexconsumer = source.getBuffer(class_1921.method_23580((class_2960)texture));
            width += 0.15f;
            speed = 0.25f;
            endAlpha = 0.0f;
        }
        float v = ((float)entity.field_6012 + partialTicks) * -0.25f * speed;
        float v1 = v + length * (inner ? 0.5f : 0.15f);
        float f4 = -width;
        float f5 = 0.0f;
        float f6 = 0.0f;
        class_4587.class_4665 posestack$pose = poseStack.method_23760();
        Matrix4f matrix4f = posestack$pose.method_23761();
        for (int j = 0; j <= vertices; ++j) {
            Matrix3f matrix3f = posestack$pose.method_23762();
            float f7 = class_3532.method_15362((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f8 = class_3532.method_15374((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f9 = (float)j + 1.0f;
            vertexconsumer.method_22918(matrix4f, f4 * 0.55f, f5 * 0.55f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, startAlpha).method_22913(f6, v).method_22922(class_4608.field_21444).method_22916(240).method_23763(matrix3f, 0.0f, -1.0f, 0.0f).method_1344();
            vertexconsumer.method_22918(matrix4f, f4, f5, length).method_22915(1.0f, 1.0f, 1.0f, endAlpha).method_22913(f6, v1).method_22922(class_4608.field_21444).method_22916(240).method_23763(matrix3f, 0.0f, -1.0f, 0.0f).method_1344();
            vertexconsumer.method_22918(matrix4f, f7, f8, length).method_22915(1.0f, 1.0f, 1.0f, endAlpha).method_22913(f9, v1).method_22922(class_4608.field_21444).method_22916(240).method_23763(matrix3f, 0.0f, -1.0f, 0.0f).method_1344();
            vertexconsumer.method_22918(matrix4f, f7 * 0.55f, f8 * 0.55f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, startAlpha).method_22913(f9, v).method_22922(class_4608.field_21444).method_22916(240).method_23763(matrix3f, 0.0f, -1.0f, 0.0f).method_1344();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.method_22909();
    }

    private static float easeOutCubic(float t) {
        float p = 1.0f - t;
        return 1.0f - p * p * p;
    }

    private static class_243 lerpVec(class_243 a, class_243 b, float t) {
        t = class_3532.method_15363((float)t, (float)0.0f, (float)1.0f);
        return a.method_1019(b.method_1020(a).method_1021((double)t));
    }

    private static class_243 predictBeamEnd(Raevyx dragon, class_243 mouthWorld, float partialTicks) {
        class_243 aimDir = dragon.getBeamAimDirection();
        if (aimDir == null || aimDir.method_1027() < 1.0E-6) {
            dragon.refreshBeamAimDirection(mouthWorld, true);
            aimDir = dragon.getBeamAimDirection();
        }
        if (aimDir == null || aimDir.method_1027() < 1.0E-6) {
            class_1309 cp = dragon.method_5642();
            if (cp instanceof class_1309) {
                class_1309 rider = cp;
                aimDir = rider.method_5828(partialTicks).method_1029();
            } else {
                class_1309 tgt = dragon.method_5968();
                if (tgt != null && tgt.method_5805()) {
                    class_243 aimPoint = tgt.method_5836(partialTicks).method_1031(0.0, -0.25, 0.0);
                    aimDir = aimPoint.method_1020(mouthWorld).method_1029();
                } else {
                    float yaw = class_3532.method_16439((float)partialTicks, (float)dragon.field_6259, (float)dragon.field_6241);
                    float pitch = class_3532.method_16439((float)partialTicks, (float)dragon.field_6004, (float)dragon.method_36455());
                    aimDir = class_243.method_1030((float)pitch, (float)yaw).method_1029();
                }
            }
        }
        double MAX_DISTANCE = 32.0;
        class_243 tentativeEnd = mouthWorld.method_1019(aimDir.method_1021(32.0));
        class_3965 hit = dragon.method_37908().method_17742(new class_3959(mouthWorld, tentativeEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)dragon));
        return hit.method_17783() != class_239.class_240.field_1333 ? hit.method_17784() : tentativeEnd;
    }

    private static final class BeamState {
        float appear;
        float disappear;
        class_243 lastMouth;
        class_243 lastEnd;

        private BeamState() {
        }
    }
}

