/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.raevyx;

import com.leon.saintsdragons.client.model.raevyx.RaevyxModel;
import com.leon.saintsdragons.client.renderer.layer.raevyx.RaevyxLightningBeamLayer;
import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@Environment(value=EnvType.CLIENT)
public class RaevyxRenderer
extends GeoEntityRenderer<Raevyx> {
    private BakedGeoModel lastBakedModel;
    private static final class_2960 TEXTURE_MALE = SaintsDragonsCommon.rl("textures/entity/raevyx/raevyx.png");
    private static final class_2960 TEXTURE_FEMALE = SaintsDragonsCommon.rl("textures/entity/raevyx/raevyx_female.png");
    private static final class_2960 TEXTURE_BABY = SaintsDragonsCommon.rl("textures/entity/raevyx/baby_raevyx.png");
    private static final float L_LEFT_X = 2.2f;
    private static final float L_LEFT_Y = 0.05f;
    private static final float L_LEFT_Z = 2.85f;
    private static final float L_RIGHT_X = -2.2f;
    private static final float L_RIGHT_Y = 0.05f;
    private static final float L_RIGHT_Z = 2.85f;
    private static final float MOUTH_X = 0.1f;
    private static final float MOUTH_Y = 8.7f;
    private static final float MOUTH_Z = -17.4f;
    private static final float BODY_X = 0.0f;
    private static final float BODY_Y = 10.0f;
    private static final float BODY_Z = 0.0f;
    private static final float PASSENGER_X = 0.0f;
    private static final float PASSENGER_Y = -3.0f;
    private static final float PASSENGER_Z = 0.0f;

    public RaevyxRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, (GeoModel)new RaevyxModel());
        this.addRenderLayer(new RaevyxLightningBeamLayer());
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull Raevyx entity) {
        if (entity.method_6109()) {
            return TEXTURE_BABY;
        }
        return entity.isFemale() ? TEXTURE_FEMALE : TEXTURE_MALE;
    }

    protected float getDeathMaxRotation(Raevyx entity) {
        return 0.0f;
    }

    public void preRender(class_4587 poseStack, Raevyx entity, BakedGeoModel model, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float scale = 1.0f;
        poseStack.method_22905(scale, scale, scale);
        this.field_4673 = 2.0f * scale;
        this.lastBakedModel = model;
        this.enableTrackingForBones(model);
        super.preRender(poseStack, (class_1297)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(@NotNull Raevyx entity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        super.method_3936((class_1297)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        this.sampleAndStashLocatorsAccurate(entity);
    }

    public class_1921 getRenderType(Raevyx animatable, class_2960 texture, @Nullable class_4597 bufferSource, float partialTick) {
        return class_1921.method_23578((class_2960)texture);
    }

    private void enableTrackingForBones(BakedGeoModel model) {
        if (model == null) {
            return;
        }
        model.getBone("leftfeet").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("rightfeet").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("head").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("heightController").ifPresent(b -> b.setTrackingMatrices(true));
        model.getBone("passengerBone").ifPresent(b -> b.setTrackingMatrices(true));
    }

    private void sampleAndStashLocatorsAccurate(Raevyx entity) {
        if (this.lastBakedModel == null || entity == null) {
            return;
        }
        this.lastBakedModel.getBone("leftfeet").ifPresent(b -> {
            class_243 world = RaevyxRenderer.transformLocator(b, 2.2f, 0.05f, 2.85f);
            if (world != null) {
                entity.setClientLocatorPosition("leftfeetLocator", world);
            }
        });
        this.lastBakedModel.getBone("rightfeet").ifPresent(b -> {
            class_243 world = RaevyxRenderer.transformLocator(b, -2.2f, 0.05f, 2.85f);
            if (world != null) {
                entity.setClientLocatorPosition("rightfeetLocator", world);
            }
        });
        this.lastBakedModel.getBone("head").ifPresent(b -> {
            class_243 world = RaevyxRenderer.transformLocator(b, 0.1f, 8.7f, -17.4f);
            if (world != null) {
                entity.setClientLocatorPosition("mouth_origin", world);
            }
        });
        this.lastBakedModel.getBone("heightController").ifPresent(b -> {
            class_243 world = RaevyxRenderer.transformLocator(b, 0.0f, 10.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition("bodyLocator", world);
            }
        });
        this.lastBakedModel.getBone("passengerBone").ifPresent(b -> {
            class_243 world = RaevyxRenderer.transformLocator(b, 0.0f, -3.0f, 0.0f);
            if (world != null) {
                entity.setClientLocatorPosition("passengerLocator", world);
            }
        });
    }

    private static class_243 transformLocator(GeoBone bone, float px, float py, float pz) {
        if (bone == null) {
            return null;
        }
        float lx = px / 16.0f;
        float ly = py / 16.0f;
        float lz = pz / 16.0f;
        Matrix4f worldMat = new Matrix4f((Matrix4fc)bone.getWorldSpaceMatrix());
        Vector4f in = new Vector4f(lx, ly, lz, 1.0f);
        Vector4f out = worldMat.transform(in);
        return new class_243((double)out.x(), (double)out.y(), (double)out.z());
    }
}

