/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.screen;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.common.network.MessageDragonAllyManagement;
import com.leon.saintsdragons.common.network.MessageDragonAllyRequest;
import com.leon.saintsdragons.common.network.ModNetworkHandler;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class DragonAllyScreen
extends class_437 {
    private final DragonEntity dragon;
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 200;
    private int leftPos;
    private int topPos;
    private class_342 usernameInput;
    private List<String> allyList;
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_ALLIES = 8;

    private int getActualGuiWidth() {
        return Math.min(256, this.field_22789 - 40);
    }

    private int getActualGuiHeight() {
        return Math.min(200, this.field_22790 - 40);
    }

    public DragonAllyScreen(DragonEntity dragon) {
        super((class_2561)class_2561.method_43471((String)"saintsdragons.gui.dragon_ally.title"));
        this.dragon = dragon;
        this.allyList = new ArrayList<String>();
    }

    protected void method_25426() {
        super.method_25426();
        int actualWidth = this.getActualGuiWidth();
        int actualHeight = this.getActualGuiHeight();
        this.leftPos = Math.max(0, (this.field_22789 - actualWidth) / 2);
        this.topPos = Math.max(0, (this.field_22790 - actualHeight) / 2);
        if (this.topPos + actualHeight > this.field_22790 - 20) {
            this.topPos = this.field_22790 - actualHeight - 20;
        }
        SaintsDragonsCommon.LOGGER.info("GUI positioning - Screen: {}x{}, GUI: {}x{}, Position: ({}, {})", new Object[]{this.field_22789, this.field_22790, 256, 200, this.leftPos, this.topPos});
        this.requestAllyListFromServer();
        this.usernameInput = new class_342(this.field_22793, this.leftPos + 20, this.topPos + 30, 150, 20, (class_2561)class_2561.method_43471((String)"saintsdragons.gui.dragon_ally.username_input"));
        this.usernameInput.method_1880(16);
        this.method_37063((class_364)this.usernameInput);
        class_4185 addButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"saintsdragons.gui.dragon_ally.add"), button -> this.addAlly()).method_46434(this.leftPos + 180, this.topPos + 30, 60, 20).method_46431();
        this.method_37063((class_364)addButton);
        class_4185 removeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"saintsdragons.gui.dragon_ally.remove"), button -> this.removeAlly()).method_46434(this.leftPos + 180, this.topPos + 55, 60, 20).method_46431();
        this.method_37063((class_364)removeButton);
        class_4185 closeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.method_25419()).method_46434(this.leftPos + 256 - 60, this.topPos + 200 - 50, 50, 20).method_46431();
        this.method_37063((class_364)closeButton);
        this.method_48265((class_364)this.usernameInput);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        int actualWidth = this.getActualGuiWidth();
        int actualHeight = this.getActualGuiHeight();
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + actualWidth, this.topPos + actualHeight, Integer.MIN_VALUE);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + actualWidth, this.topPos + 1, -2838729);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + actualHeight, -2838729);
        guiGraphics.method_25294(this.leftPos + actualWidth - 1, this.topPos, this.leftPos + actualWidth, this.topPos + actualHeight, -2838729);
        guiGraphics.method_25294(this.leftPos, this.topPos + actualHeight - 1, this.leftPos + actualWidth, this.topPos + actualHeight, -2838729);
        guiGraphics.method_25294(this.leftPos + 10, this.topPos + 10, this.leftPos + actualWidth - 10, this.topPos + 12, -4684277);
        guiGraphics.method_25294(this.leftPos + 10, this.topPos + actualHeight - 12, this.leftPos + actualWidth - 10, this.topPos + actualHeight - 10, -4684277);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.leftPos + 128, this.topPos + 16, 0x404040);
        String allyCountText = class_2561.method_43469((String)"saintsdragons.gui.dragon_ally.count", (Object[])new Object[]{this.allyList.size(), this.dragon.allyManager.getMaxAllies()}).getString();
        guiGraphics.method_25303(this.field_22793, allyCountText, this.leftPos + 20, this.topPos + 80, 0x404040);
        this.drawAllyList(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void drawAllyList(class_332 guiGraphics) {
        int index;
        int startY = this.topPos + 100;
        int endY = this.topPos + 200 - 40;
        int visibleCount = Math.min(8, this.allyList.size() - this.scrollOffset);
        for (int i = 0; i < visibleCount && (index = i + this.scrollOffset) < this.allyList.size(); ++i) {
            String allyName = this.allyList.get(index);
            int y = startY + i * 12;
            int color = 0x404040;
            guiGraphics.method_25303(this.field_22793, allyName, this.leftPos + 20, y, color);
        }
        if (this.allyList.size() > 8) {
            if (this.scrollOffset > 0) {
                guiGraphics.method_25303(this.field_22793, "\u2191", this.leftPos + 256 - 20, startY, 0x404040);
            }
            if (this.scrollOffset + 8 < this.allyList.size()) {
                guiGraphics.method_25303(this.field_22793, "\u2193", this.leftPos + 256 - 20, endY - 12, 0x404040);
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.allyList.size() > 8) {
            if (delta < 0.0 && this.scrollOffset < this.allyList.size() - 8) {
                ++this.scrollOffset;
            } else if (delta > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int index;
            int startY = this.topPos + 100;
            for (int i = 0; i < Math.min(8, this.allyList.size() - this.scrollOffset) && (index = i + this.scrollOffset) < this.allyList.size(); ++i) {
                int y = startY + i * 12;
                if (!(mouseX >= (double)(this.leftPos + 20)) || !(mouseX <= (double)(this.leftPos + 256 - 40)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 12))) continue;
                String allyName = this.allyList.get(index);
                this.usernameInput.method_1852(allyName);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void addAlly() {
        String username = this.usernameInput.method_1882().trim();
        if (username.isEmpty()) {
            return;
        }
        ModNetworkHandler.sendToServer(new MessageDragonAllyManagement(this.dragon.method_5628(), MessageDragonAllyManagement.Action.ADD, username));
        this.usernameInput.method_1852("");
    }

    private void removeAlly() {
        String username = this.usernameInput.method_1882().trim();
        if (username.isEmpty()) {
            return;
        }
        ModNetworkHandler.sendToServer(new MessageDragonAllyManagement(this.dragon.method_5628(), MessageDragonAllyManagement.Action.REMOVE, username));
        this.usernameInput.method_1852("");
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257) {
            this.addAlly();
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    private void requestAllyListFromServer() {
        ModNetworkHandler.sendToServer(new MessageDragonAllyRequest(this.dragon.method_5628()));
    }

    public void updateAllyList(List<String> newAllyList) {
        this.allyList = newAllyList;
        this.scrollOffset = Math.min(this.scrollOffset, Math.max(0, this.allyList.size() - 8));
    }

    public void addAlly(String username) {
        if (!this.allyList.contains(username)) {
            this.allyList.add(username);
            this.scrollOffset = Math.min(this.scrollOffset, Math.max(0, this.allyList.size() - 8));
        }
    }

    public void removeAlly(String username) {
        this.allyList.remove(username);
        this.scrollOffset = Math.min(this.scrollOffset, Math.max(0, this.allyList.size() - 8));
    }
}

