/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.ui;

import com.leon.saintsdragons.client.ui.DragonHealthBar;
import com.leon.saintsdragons.client.ui.DragonSpeedIndicator;
import com.leon.saintsdragons.client.ui.DragonUIElement;
import com.leon.saintsdragons.client.ui.MeleeModeNotification;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class DragonStatusUI {
    private static final long SLIDE_DURATION_MS = 250L;
    private final class_310 minecraft;
    private final List<DragonUIElement> elements = new ArrayList<DragonUIElement>();
    private final DragonHealthBar healthBar;
    private final DragonSpeedIndicator speedIndicator;
    private final MeleeModeNotification meleeModeNotification;
    private int cachedScreenWidth = -1;
    private int cachedScreenHeight = -1;
    private boolean visible = false;
    private DragonEntity currentDragon = null;
    private boolean animationActive = false;
    private boolean animatingIn = false;
    private long animationStartTime = 0L;
    private int healthBarSlideDistance = 0;
    private int speedIndicatorSlideDistance = 0;

    public DragonStatusUI() {
        this.minecraft = class_310.method_1551();
        this.healthBar = new DragonHealthBar(0, 0);
        this.speedIndicator = new DragonSpeedIndicator(0, 0);
        this.meleeModeNotification = new MeleeModeNotification();
        this.elements.add(this.healthBar);
        this.elements.add(this.speedIndicator);
        this.updateElementPositions();
        this.loadPositions();
    }

    private void updateElementPositions() {
        if (this.minecraft == null) {
            this.applyFallbackLayout();
            return;
        }
        int screenWidth = this.minecraft.method_22683().method_4486();
        int screenHeight = this.minecraft.method_22683().method_4502();
        if (screenWidth <= 0 || screenHeight <= 0) {
            this.applyFallbackLayout();
            return;
        }
        if (screenWidth == this.cachedScreenWidth && screenHeight == this.cachedScreenHeight) {
            return;
        }
        this.cachedScreenWidth = screenWidth;
        this.cachedScreenHeight = screenHeight;
        int leftMargin = Math.max(12, (int)((float)screenWidth * 0.02f));
        int topMargin = Math.max(14, (int)((float)screenHeight * 0.025f));
        int healthBarX = leftMargin;
        int healthBarY = topMargin;
        int spacing = Math.max(8, (int)((float)screenHeight * 0.018f));
        int speedY = healthBarY + this.healthBar.getHeight() + spacing;
        this.healthBar.setPosition(healthBarX, healthBarY);
        this.speedIndicator.setPosition(leftMargin, speedY);
        this.updateSlideDistances();
    }

    private void applyFallbackLayout() {
        this.healthBar.setPosition(10, 10);
        this.speedIndicator.setPosition(10, 120);
        this.updateSlideDistances();
    }

    public void updateDragon(DragonEntity dragon) {
        this.currentDragon = dragon;
        if (dragon != null) {
            this.healthBar.setDragon(dragon);
            this.speedIndicator.setDragon(dragon);
        }
        this.updateElementPositions();
    }

    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible || this.currentDragon == null) {
            return;
        }
        class_746 player = this.minecraft.field_1724;
        if (player == null || player.method_5854() != this.currentDragon) {
            return;
        }
        boolean animating = this.animationActive && this.animatingIn;
        float animationProgress = 1.0f;
        if (animating) {
            long elapsed = System.currentTimeMillis() - this.animationStartTime;
            animationProgress = Math.min(1.0f, Math.max(0.0f, (float)elapsed / 250.0f));
        }
        float easedProgress = animating ? DragonStatusUI.easeOutCubic(animationProgress) : 1.0f;
        int screenWidth = this.getCurrentScreenWidth();
        if (screenWidth <= 0) {
            screenWidth = this.cachedScreenWidth > 0 ? this.cachedScreenWidth : 400;
        }
        int healthOffsetX = 0;
        int speedOffsetX = 0;
        if (animating) {
            int healthMagnitude = Math.round((1.0f - easedProgress) * (float)this.healthBarSlideDistance);
            int speedMagnitude = Math.round((1.0f - easedProgress) * (float)this.speedIndicatorSlideDistance);
            healthOffsetX = this.drawsFromRight(this.healthBar, screenWidth) ? healthMagnitude : -healthMagnitude;
            speedOffsetX = this.drawsFromRight(this.speedIndicator, screenWidth) ? speedMagnitude : -speedMagnitude;
        }
        for (DragonUIElement element : this.elements) {
            if (element == this.healthBar) {
                this.healthBar.renderWithOffset(guiGraphics, mouseX, mouseY, partialTicks, healthOffsetX, 0);
                continue;
            }
            if (element == this.speedIndicator) {
                this.speedIndicator.renderWithOffset(guiGraphics, mouseX, mouseY, partialTicks, speedOffsetX, 0);
                continue;
            }
            element.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (animating && animationProgress >= 1.0f) {
            this.animationActive = false;
            this.animatingIn = false;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible || this.isAnimating()) {
            return false;
        }
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            DragonUIElement element = this.elements.get(i);
            if (!element.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.visible || this.isAnimating()) {
            return false;
        }
        boolean handled = false;
        for (DragonUIElement element : this.elements) {
            if (!element.mouseReleased(mouseX, mouseY, button)) continue;
            handled = true;
        }
        if (handled) {
            this.savePositions();
        }
        return handled;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.visible || this.isAnimating()) {
            return false;
        }
        boolean handled = false;
        for (DragonUIElement element : this.elements) {
            if (!element.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            handled = true;
        }
        return handled;
    }

    public void toggleVisibility() {
        this.setVisible(!this.visible);
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            if (visible && !this.isAnimating()) {
                this.startEnterAnimation();
            }
            return;
        }
        this.visible = visible;
        if (visible) {
            this.updateElementPositions();
            this.startEnterAnimation();
            this.updateDragon(this.currentDragon);
        } else {
            this.animationActive = false;
            this.animatingIn = false;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public MeleeModeNotification getMeleeModeNotification() {
        return this.meleeModeNotification;
    }

    public void savePositions() {
    }

    private void loadPositions() {
    }

    public void onWindowResize() {
        this.updateElementPositions();
        if (this.visible) {
            this.savePositions();
        }
    }

    private boolean isAnimating() {
        return this.animationActive && this.animatingIn;
    }

    private void startEnterAnimation() {
        this.updateSlideDistances();
        if (this.healthBarSlideDistance == 0 && this.speedIndicatorSlideDistance == 0) {
            this.animationActive = false;
            this.animatingIn = false;
            return;
        }
        this.animationActive = true;
        this.animatingIn = true;
        this.animationStartTime = System.currentTimeMillis();
    }

    private void updateSlideDistances() {
        int screenWidth = this.getCurrentScreenWidth();
        if (screenWidth <= 0) {
            screenWidth = this.cachedScreenWidth > 0 ? this.cachedScreenWidth : 400;
        }
        this.healthBarSlideDistance = this.computeSlideDistance(this.healthBar, screenWidth);
        this.speedIndicatorSlideDistance = this.computeSlideDistance(this.speedIndicator, screenWidth);
    }

    private int computeSlideDistance(DragonUIElement element, int screenWidth) {
        if (element == null) {
            return 0;
        }
        if (this.drawsFromRight(element, screenWidth)) {
            return Math.max(0, screenWidth - element.getX() + element.getWidth());
        }
        return Math.max(0, element.getX() + element.getWidth());
    }

    private boolean drawsFromRight(DragonUIElement element, int screenWidth) {
        return element.getX() + element.getWidth() / 2 >= screenWidth / 2;
    }

    private int getCurrentScreenWidth() {
        if (this.minecraft != null) {
            return this.minecraft.method_22683().method_4486();
        }
        return this.cachedScreenWidth;
    }

    private static float easeOutCubic(float t) {
        float inverted = 1.0f - t;
        return 1.0f - inverted * inverted * inverted;
    }
}

