/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.ui;

import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class DragonUIElement {
    protected final class_310 minecraft = class_310.method_1551();
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean visible = true;
    protected boolean dragging = false;
    protected int dragOffsetX;
    protected int dragOffsetY;

    public DragonUIElement(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public abstract void render(class_332 var1, int var2, int var3, float var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderWithOffset(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks, int offsetX, int offsetY) {
        if (offsetX == 0 && offsetY == 0) {
            this.render(guiGraphics, mouseX, mouseY, partialTicks);
            return;
        }
        int originalX = this.x;
        int originalY = this.y;
        this.x = originalX + offsetX;
        this.y = originalY + offsetY;
        try {
            this.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        finally {
            this.x = originalX;
            this.y = originalY;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOver(mouseX, mouseY)) {
            this.startDragging(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            this.x = (int)(mouseX - (double)this.dragOffsetX);
            this.y = (int)(mouseY - (double)this.dragOffsetY);
            this.clampToScreen();
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    protected void startDragging(double mouseX, double mouseY) {
        this.dragging = true;
        this.dragOffsetX = (int)(mouseX - (double)this.x);
        this.dragOffsetY = (int)(mouseY - (double)this.y);
    }

    protected void clampToScreen() {
        int screenWidth = this.minecraft.method_22683().method_4486();
        int screenHeight = this.minecraft.method_22683().method_4502();
        this.x = Math.max(0, Math.min(this.x, screenWidth - this.width));
        this.y = Math.max(0, Math.min(this.y, screenHeight - this.height));
    }

    public String getPositionString() {
        return this.x + "," + this.y;
    }

    public void setPositionFromString(String position) {
        try {
            String[] parts = position.split(",");
            if (parts.length == 2) {
                this.x = Integer.parseInt(parts[0]);
                this.y = Integer.parseInt(parts[1]);
                this.clampToScreen();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.clampToScreen();
    }
}

