/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.item;

import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NulljawBinderItem
extends class_1792 {
    private static final String BOUND_DRAGON_UUID = "BoundDragonUUID";
    private static final String BOUND_DRAGON_NAME = "BoundDragonName";
    private static final String BOUND_OWNER_UUID = "BoundOwnerUUID";
    private static final String BOUND_OWNER_NAME = "BoundOwnerName";
    private static final String BOUND_CUSTOM_NAME = "BoundCustomName";
    private static final String DRAGON_DATA_KEY = "RiftDrakeData";
    private static final String IS_BOUND = "IsBound";

    public NulljawBinderItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @NotNull
    public class_1269 method_7847(@NotNull class_1799 stack, @NotNull class_1657 player, @NotNull class_1309 target, @NotNull class_1268 hand) {
        if (!(target instanceof Nulljaw)) {
            return class_1269.field_5811;
        }
        Nulljaw drake = (Nulljaw)target;
        if (!drake.method_6181() || !drake.method_6171((class_1309)player)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"saintsdragons.message.not_dragon_owner"), true);
            return class_1269.field_5814;
        }
        if (!drake.canBeBound()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"saintsdragons.message.nulljaw_cannot_be_captured"), true);
            return class_1269.field_5814;
        }
        if (NulljawBinderItem.isBound(stack)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"saintsdragons.message.binder_already_occupied"), true);
            return class_1269.field_5814;
        }
        class_1799 newStack = this.captureDrake(stack, drake, player);
        if (hand == class_1268.field_5808) {
            player.method_31548().method_5447(player.method_31548().field_7545, newStack);
        } else {
            player.method_31548().method_5447(40, newStack);
        }
        return class_1269.field_5812;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        return NulljawBinderItem.isBound(stack) ? class_1271.method_22430((Object)stack) : super.method_7836(level, player, hand);
    }

    @NotNull
    public class_1269 method_7884(@NotNull class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            return super.method_7884(context);
        }
        class_1799 stack = context.method_8041();
        if (!NulljawBinderItem.isBound(stack)) {
            return super.method_7884(context);
        }
        return this.releaseDrake(stack, player, context.method_8037()) ? class_1269.field_5812 : class_1269.field_5814;
    }

    private class_1799 captureDrake(class_1799 stack, Nulljaw drake, class_1657 player) {
        class_1799 copied = stack.method_7972();
        class_2487 tag = copied.method_7948();
        tag.method_25927(BOUND_DRAGON_UUID, drake.method_5667());
        tag.method_10582(BOUND_DRAGON_NAME, drake.method_5477().getString());
        if (drake.method_16914()) {
            tag.method_10582(BOUND_CUSTOM_NAME, class_2561.class_2562.method_10867((class_2561)drake.method_5797()));
        } else {
            tag.method_10551(BOUND_CUSTOM_NAME);
        }
        tag.method_10556(IS_BOUND, true);
        class_1309 owner = drake.method_35057();
        if (owner instanceof class_1657) {
            class_1657 ownerPlayer = (class_1657)owner;
            tag.method_25927(BOUND_OWNER_UUID, ownerPlayer.method_5667());
            tag.method_10582(BOUND_OWNER_NAME, ownerPlayer.method_5477().getString());
        } else {
            tag.method_10551(BOUND_OWNER_UUID);
            tag.method_10551(BOUND_OWNER_NAME);
        }
        class_2487 drakeData = new class_2487();
        drake.method_5652(drakeData);
        tag.method_10566(DRAGON_DATA_KEY, (class_2520)drakeData);
        copied.method_7980(tag);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            for (int i = 0; i < serverPlayer.method_31548().method_5439(); ++i) {
                if (serverPlayer.method_31548().method_5438(i) != stack) continue;
                serverPlayer.method_31548().method_5447(i, copied);
                break;
            }
        }
        drake.method_5650(class_1297.class_5529.field_26999);
        player.method_7353((class_2561)class_2561.method_43469((String)"saintsdragons.message.nulljaw_captured", (Object[])new Object[]{drake.method_5477().getString()}), true);
        return copied;
    }

    private boolean releaseDrake(class_1799 stack, class_1657 player, class_2338 pos) {
        class_5250 customName;
        UUID ownerUUID;
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545(BOUND_DRAGON_UUID)) {
            return false;
        }
        UUID uUID = ownerUUID = tag.method_10545(BOUND_OWNER_UUID) ? tag.method_25926(BOUND_OWNER_UUID) : null;
        if (ownerUUID != null && !player.method_5667().equals(ownerUUID)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"saintsdragons.message.cannot_release_others_dragon"), true);
            return false;
        }
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return true;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        String drakeName = tag.method_10558(BOUND_DRAGON_NAME);
        Nulljaw newDrake = new Nulljaw((class_1299<? extends Nulljaw>)ModEntities.NULLJAW.get(), (class_1937)serverLevel);
        if (tag.method_10545(DRAGON_DATA_KEY)) {
            class_2487 drakeData = tag.method_10562(DRAGON_DATA_KEY);
            newDrake.method_5749(drakeData);
        }
        newDrake.method_5814((double)pos.method_10263() + 0.5, pos.method_10264() + 1, (double)pos.method_10260() + 0.5);
        if (ownerUUID != null) {
            class_1657 owner = serverLevel.method_18470(ownerUUID);
            if (owner != null) {
                newDrake.method_6170(owner);
            } else {
                newDrake.method_6173(true);
                newDrake.method_6174(ownerUUID);
            }
        } else {
            newDrake.method_6170(player);
        }
        if (tag.method_10545(BOUND_CUSTOM_NAME) && (customName = class_2561.class_2562.method_10877((String)tag.method_10558(BOUND_CUSTOM_NAME))) != null) {
            newDrake.method_5665((class_2561)customName);
        }
        serverLevel.method_8649((class_1297)newDrake);
        tag.method_10551(BOUND_DRAGON_UUID);
        tag.method_10551(BOUND_DRAGON_NAME);
        tag.method_10551(BOUND_OWNER_UUID);
        tag.method_10551(BOUND_OWNER_NAME);
        tag.method_10551(BOUND_CUSTOM_NAME);
        tag.method_10551(DRAGON_DATA_KEY);
        tag.method_10556(IS_BOUND, false);
        player.method_7353((class_2561)class_2561.method_43469((String)"saintsdragons.message.nulljaw_released", (Object[])new Object[]{drakeName}), true);
        return true;
    }

    public static boolean isBound(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10577(IS_BOUND);
    }

    @Nullable
    public static UUID getBoundRiftDrakeUUID(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_25928(BOUND_DRAGON_UUID)) {
            return tag.method_25926(BOUND_DRAGON_UUID);
        }
        return null;
    }

    @Nullable
    public static String getBoundRiftDrakeName(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10545(BOUND_DRAGON_NAME)) {
            return tag.method_10558(BOUND_DRAGON_NAME);
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"saintsdragons.tooltip.nulljaw.description"));
        if (NulljawBinderItem.isBound(stack)) {
            String name = NulljawBinderItem.getBoundRiftDrakeName(stack);
            if (name != null && !name.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"saintsdragons.tooltip.nulljaw.bound", (Object[])new Object[]{name}));
            }
            tooltip.add((class_2561)class_2561.method_43471((String)"saintsdragons.tooltip.nulljaw.right_click_to_release"));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"saintsdragons.tooltip.nulljaw.empty"));
            tooltip.add((class_2561)class_2561.method_43471((String)"saintsdragons.tooltip.nulljaw.right_click_nulljaw_to_bind"));
        }
    }

    public boolean method_7886(@NotNull class_1799 stack) {
        return NulljawBinderItem.isBound(stack);
    }
}

