/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.common.network.MessageDragonAllyDelta;
import com.leon.saintsdragons.common.network.NetworkHandler;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.handler.DragonAllyManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class MessageDragonAllyManagement {
    private final int dragonId;
    private final Action action;
    private final String username;

    public MessageDragonAllyManagement(int dragonId, Action action, String username) {
        this.dragonId = dragonId;
        this.action = action;
        this.username = username;
    }

    private MessageDragonAllyManagement(class_2540 buffer) {
        this.dragonId = buffer.readInt();
        this.action = (Action)buffer.method_10818(Action.class);
        this.username = buffer.method_10800(16);
    }

    public static void encode(MessageDragonAllyManagement message, class_2540 buffer) {
        buffer.writeInt(message.dragonId);
        buffer.method_10817((Enum)message.action);
        buffer.method_10788(message.username, 16);
    }

    public static MessageDragonAllyManagement decode(class_2540 buffer) {
        return new MessageDragonAllyManagement(buffer);
    }

    public static void handle(MessageDragonAllyManagement message, class_3222 player) {
        class_5250 resultMessage;
        if (player == null) {
            return;
        }
        class_1297 entity = player.method_37908().method_8469(message.dragonId);
        if (!(entity instanceof DragonEntity)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"saintsdragons.message.dragon_not_found"));
            return;
        }
        DragonEntity dragon = (DragonEntity)entity;
        if (!dragon.method_6181() || !dragon.method_6171((class_1309)player)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"saintsdragons.message.not_dragon_owner"));
            return;
        }
        DragonAllyManager allyManager = dragon.allyManager;
        DragonAllyManager.AllyResult result = switch (message.action) {
            case Action.ADD -> allyManager.addAlly(message.username);
            case Action.REMOVE -> allyManager.removeAlly(message.username);
            default -> DragonAllyManager.AllyResult.INVALID_USERNAME;
        };
        if (result == DragonAllyManager.AllyResult.EASTER_EGG) {
            resultMessage = switch (message.username.toLowerCase()) {
                case "notch" -> class_2561.method_43471((String)"saintsdragons.message.easter_egg.notch");
                case "jeb_" -> class_2561.method_43471((String)"saintsdragons.message.easter_egg.jeb_");
                case "dinnerbone" -> class_2561.method_43471((String)"saintsdragons.message.easter_egg.dinnerbone");
                case "grumm" -> class_2561.method_43471((String)"saintsdragons.message.easter_egg.grumm");
                case "herobrine" -> class_2561.method_43471((String)"saintsdragons.message.easter_egg.herobrine");
                default -> class_2561.method_43471((String)"saintsdragons.message.ally.easter_egg");
            };
        } else {
            resultMessage = class_2561.method_43469((String)("saintsdragons.message.ally." + result.name().toLowerCase()), (Object[])new Object[]{message.username});
        }
        player.method_43496((class_2561)resultMessage);
        if (result == DragonAllyManager.AllyResult.SUCCESS) {
            boolean isAdd = message.action == Action.ADD;
            NetworkHandler.sendToPlayer(player, new MessageDragonAllyDelta(dragon.method_5628(), message.username, isAdd));
        }
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

