/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public record MessageDragonRideInput(boolean goingUp, boolean goingDown, DragonRiderAction action, String abilityName, float forward, float strafe, float yaw) {
    public boolean hasAbilityName() {
        return this.abilityName != null && !this.abilityName.isEmpty();
    }

    public static void encode(MessageDragonRideInput msg, class_2540 buf) {
        buf.writeBoolean(msg.goingUp());
        buf.writeBoolean(msg.goingDown());
        buf.method_10817((Enum)(msg.action() != null ? msg.action() : DragonRiderAction.NONE));
        if (msg.action() == DragonRiderAction.ABILITY_USE || msg.action() == DragonRiderAction.ABILITY_STOP) {
            buf.method_10814(msg.abilityName() != null ? msg.abilityName() : "");
        }
        buf.writeFloat(msg.forward());
        buf.writeFloat(msg.strafe());
        buf.writeFloat(msg.yaw());
    }

    public static MessageDragonRideInput decode(class_2540 buf) {
        boolean goingUp = buf.readBoolean();
        boolean goingDown = buf.readBoolean();
        DragonRiderAction action = (DragonRiderAction)buf.method_10818(DragonRiderAction.class);
        String abilityName = null;
        if ((action == DragonRiderAction.ABILITY_USE || action == DragonRiderAction.ABILITY_STOP) && (abilityName = buf.method_19772()).isEmpty()) {
            abilityName = null;
        }
        float forward = buf.readFloat();
        float strafe = buf.readFloat();
        float yaw = buf.readFloat();
        return new MessageDragonRideInput(goingUp, goingDown, action, abilityName, forward, strafe, yaw);
    }

    public static void handle(MessageDragonRideInput msg, class_3222 player) {
        RideableDragonBase dragon;
        if (player == null) {
            return;
        }
        class_1297 vehicle = player.method_5854();
        if (vehicle instanceof RideableDragonBase && (dragon = (RideableDragonBase)vehicle).canBeControlledBy((class_1657)player)) {
            dragon.handleRiderNetworkInput(player, msg);
        }
    }
}

