/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.registry;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1309;

public final class AbilityRegistry {
    private static final Map<String, DragonAbilityType<?, ?>> BY_NAME = new HashMap();
    private static final Map<DragonAbilityType<?, ?>, String> BY_TYPE = new IdentityHashMap();

    private AbilityRegistry() {
    }

    public static synchronized <M extends class_1309, T extends DragonAbility<M>> DragonAbilityType<M, T> register(DragonAbilityType<M, T> type) {
        return AbilityRegistry.register(type.getName(), type);
    }

    public static synchronized <M extends class_1309, T extends DragonAbility<M>> DragonAbilityType<M, T> register(String name, DragonAbilityType<M, T> type) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Ability name must not be null/empty");
        }
        DragonAbilityType<M, T> existing = BY_NAME.putIfAbsent(name, type);
        if (existing != null && existing != type) {
            throw new IllegalStateException("Duplicate ability name: " + name);
        }
        BY_TYPE.putIfAbsent(type, name);
        return type;
    }

    public static DragonAbilityType<?, ?> get(String name) {
        return BY_NAME.get(name);
    }

    public static String getName(DragonAbilityType<?, ?> type) {
        return BY_TYPE.get(type);
    }
}

