/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.registry;

import com.leon.saintsdragons.common.registry.Element;
import com.leon.saintsdragons.common.registry.ElementalProfile;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_6862;
import net.minecraft.class_8103;
import net.minecraft.class_8110;

public enum DragonType {
    LIGHTNING("lightning", Element.LIGHTNING, Raevyx.class, ModEntities.RAEVYX, ElementalProfile.builder(Element.LIGHTNING).immuneTo((class_6862<class_8110>)class_8103.field_42253).build()),
    FIRE("fire", Element.FIRE, Cindervane.class, ModEntities.CINDERVANE, ElementalProfile.builder(Element.FIRE).immuneTo((class_6862<class_8110>)class_8103.field_42246).build()),
    PHYSICAL_BRUTE("physical", Element.NONE, Nulljaw.class, ModEntities.NULLJAW, ElementalProfile.builder(Element.NONE).resistantTo((class_6862<class_8110>)class_8103.field_42251, 0.5f).build()),
    PHYSICAL_SUPPORT("physical", Element.NONE, Stegonaut.class, ModEntities.STEGONAUT, ElementalProfile.builder(Element.NONE).resistantTo((class_6862<class_8110>)class_8103.field_42250, 0.3f).build());

    private final String name;
    private final Element element;
    private final Class<? extends DragonEntity> entityClass;
    private final Supplier<? extends class_1299<? extends DragonEntity>> entityType;
    private final ElementalProfile elementalProfile;

    private DragonType(String name, Element element, Class<? extends DragonEntity> entityClass, Supplier<? extends class_1299<? extends DragonEntity>> entityType, ElementalProfile elementalProfile) {
        this.name = name;
        this.element = element;
        this.entityClass = entityClass;
        this.entityType = entityType;
        this.elementalProfile = elementalProfile;
    }

    public String getName() {
        return this.name;
    }

    public Element getElement() {
        return this.element;
    }

    public ElementalProfile getElementalProfile() {
        return this.elementalProfile;
    }

    public boolean hasElementalAttacks() {
        return this.element.isElemental();
    }

    public Class<? extends DragonEntity> getEntityClass() {
        return this.entityClass;
    }

    public Supplier<? extends class_1299<? extends DragonEntity>> getEntityType() {
        return this.entityType;
    }

    public class_1299<? extends DragonEntity> getEntityTypeValue() {
        return this.entityType.get();
    }

    public boolean isInstance(DragonEntity entity) {
        return this.entityClass.isInstance((Object)entity);
    }

    public static DragonType fromEntityClass(Class<? extends DragonEntity> entityClass) {
        for (DragonType type : DragonType.values()) {
            if (!type.entityClass.equals(entityClass)) continue;
            return type;
        }
        return null;
    }

    public static DragonType fromEntity(DragonEntity entity) {
        return DragonType.fromEntityClass(((Object)((Object)entity)).getClass());
    }
}

