/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.registry;

import com.leon.saintsdragons.common.registry.Element;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_6862;
import net.minecraft.class_8110;

public class ElementalProfile {
    private final Element element;
    private final Set<class_6862<class_8110>> immunities;
    private final Map<class_6862<class_8110>, Float> resistances;
    private final Map<class_6862<class_8110>, Float> weaknesses;

    private ElementalProfile(Builder builder) {
        this.element = builder.element;
        this.immunities = Set.copyOf(builder.immunities);
        this.resistances = Map.copyOf(builder.resistances);
        this.weaknesses = Map.copyOf(builder.weaknesses);
    }

    public Element getElement() {
        return this.element;
    }

    public boolean isImmuneTo(class_1282 source) {
        return this.immunities.stream().anyMatch(arg_0 -> ((class_1282)source).method_48789(arg_0));
    }

    public float getDamageMultiplier(class_1282 source) {
        if (this.isImmuneTo(source)) {
            return 0.0f;
        }
        for (Map.Entry<class_6862<class_8110>, Float> entry : this.resistances.entrySet()) {
            if (!source.method_48789(entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        for (Map.Entry<class_6862<class_8110>, Float> entry : this.weaknesses.entrySet()) {
            if (!source.method_48789(entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 1.0f;
    }

    public static Builder builder(Element element) {
        return new Builder(element);
    }

    public static class Builder {
        private final Element element;
        private final Set<class_6862<class_8110>> immunities = new HashSet<class_6862<class_8110>>();
        private final Map<class_6862<class_8110>, Float> resistances = new HashMap<class_6862<class_8110>, Float>();
        private final Map<class_6862<class_8110>, Float> weaknesses = new HashMap<class_6862<class_8110>, Float>();

        private Builder(Element element) {
            this.element = element;
        }

        public Builder immuneTo(class_6862<class_8110> damageType) {
            this.immunities.add(damageType);
            return this;
        }

        public Builder resistantTo(class_6862<class_8110> damageType, float multiplier) {
            if (multiplier < 0.0f || multiplier >= 1.0f) {
                throw new IllegalArgumentException("Resistance multiplier must be between 0.0 and 1.0 (exclusive)");
            }
            this.resistances.put(damageType, Float.valueOf(multiplier));
            return this;
        }

        public Builder weakTo(class_6862<class_8110> damageType, float multiplier) {
            if (multiplier <= 1.0f) {
                throw new IllegalArgumentException("Weakness multiplier must be greater than 1.0");
            }
            this.weaknesses.put(damageType, Float.valueOf(multiplier));
            return this;
        }

        public ElementalProfile build() {
            return new ElementalProfile(this);
        }
    }
}

