/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.fabric.platform;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.fabric.config.SaintsDragonsFabricConfig;
import com.leon.saintsdragons.platform.ConfigHelper;
import java.util.function.IntSupplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;

final class FabricClothConfigHelper
implements ConfigHelper {
    private static volatile ConfigHolder<SaintsDragonsFabricConfig> holder;

    FabricClothConfigHelper() {
    }

    static FabricClothConfigHelper create() {
        return new FabricClothConfigHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConfigHolder<SaintsDragonsFabricConfig> holder() {
        ConfigHolder current = holder;
        if (current != null) return current;
        Class<FabricClothConfigHelper> clazz = FabricClothConfigHelper.class;
        synchronized (FabricClothConfigHelper.class) {
            current = holder;
            if (current != null) return current;
            SaintsDragonsCommon.LOGGER.info("[Fabric] Detected Cloth Config; enabling editable spawn config");
            AutoConfig.register(SaintsDragonsFabricConfig.class, Toml4jConfigSerializer::new);
            holder = current = AutoConfig.getConfigHolder(SaintsDragonsFabricConfig.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return current;
        }
    }

    @Override
    public ConfigHelper.ConfigBuilder commonBuilder(String fileName) {
        FabricClothConfigHelper.holder();
        return new ClothBuilder();
    }

    private static IntSupplier supplierForKey(String key, int defaultValue) {
        return switch (key) {
            case "raevyxSpawnWeight" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).raevyxSpawnWeight;
            case "raevyxMinGroupSize" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).raevyxMinGroupSize;
            case "raevyxMaxGroupSize" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).raevyxMaxGroupSize;
            case "stegonautSpawnWeight" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).stegonautSpawnWeight;
            case "stegonautMinGroupSize" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).stegonautMinGroupSize;
            case "stegonautMaxGroupSize" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).stegonautMaxGroupSize;
            case "cindervaneSpawnWeight" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).cindervaneSpawnWeight;
            case "cindervaneMinGroupSize" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).cindervaneMinGroupSize;
            case "cindervaneMaxGroupSize" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).cindervaneMaxGroupSize;
            case "nulljawSpawnWeight" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).nulljawSpawnWeight;
            case "nulljawMinGroupSize" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).nulljawMinGroupSize;
            case "nulljawMaxGroupSize" -> () -> ((SaintsDragonsFabricConfig)FabricClothConfigHelper.holder().getConfig()).nulljawMaxGroupSize;
            default -> {
                SaintsDragonsCommon.LOGGER.warn("Unknown Fabric config key '{}'; using default {}", (Object)key, (Object)defaultValue);
                yield () -> defaultValue;
            }
        };
    }

    private static final class ClothBuilder
    implements ConfigHelper.ConfigBuilder {
        private ClothBuilder() {
        }

        @Override
        public void push(String category) {
        }

        @Override
        public void pop() {
        }

        @Override
        public ConfigHelper.IntValue defineInt(String key, int defaultValue, int min, int max) {
            IntSupplier supplier = FabricClothConfigHelper.supplierForKey(key, defaultValue);
            return new ClothIntValue(supplier, min, max);
        }

        @Override
        public void build() {
            FabricClothConfigHelper.holder().save();
        }
    }

    private static final class ClothIntValue
    implements ConfigHelper.IntValue {
        private final IntSupplier supplier;
        private final int min;
        private final int max;

        private ClothIntValue(IntSupplier supplier, int min, int max) {
            this.supplier = supplier;
            this.min = min;
            this.max = max;
        }

        @Override
        public int get() {
            int value = this.supplier.getAsInt();
            if (value < this.min) {
                return this.min;
            }
            if (value > this.max) {
                return this.max;
            }
            return value;
        }
    }
}

