/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.fabric.platform;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.fabric.platform.FabricClothConfigHelper;
import com.leon.saintsdragons.platform.ConfigHelper;
import net.fabricmc.loader.api.FabricLoader;

public final class FabricConfigHelper
implements ConfigHelper {
    private final ConfigHelper delegate = FabricConfigHelper.createDelegate();

    @Override
    public ConfigHelper.ConfigBuilder commonBuilder(String fileName) {
        return this.delegate.commonBuilder(fileName);
    }

    private static ConfigHelper createDelegate() {
        if (FabricLoader.getInstance().isModLoaded("cloth-config")) {
            try {
                return FabricClothConfigHelper.create();
            }
            catch (Throwable throwable) {
                SaintsDragonsCommon.LOGGER.error("[Fabric] Failed to initialise Cloth Config integration; falling back to defaults", throwable);
            }
        } else {
            SaintsDragonsCommon.LOGGER.info("[Fabric] Cloth Config not detected; using default spawn config values");
        }
        return new FabricDefaultConfigHelper();
    }

    private static final class FabricDefaultConfigHelper
    implements ConfigHelper {
        private FabricDefaultConfigHelper() {
        }

        @Override
        public ConfigHelper.ConfigBuilder commonBuilder(String fileName) {
            return new DefaultBuilder();
        }

        private static final class DefaultBuilder
        implements ConfigHelper.ConfigBuilder {
            private DefaultBuilder() {
            }

            @Override
            public void push(String category) {
            }

            @Override
            public void pop() {
            }

            @Override
            public ConfigHelper.IntValue defineInt(String key, int defaultValue, int min, int max) {
                return () -> Math.max(min, Math.min(max, defaultValue));
            }

            @Override
            public void build() {
            }
        }
    }
}

