/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.fabric.platform;

import com.leon.saintsdragons.platform.NetworkHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class FabricNetworkHelper
implements NetworkHelper {
    private final Map<Class<?>, Binding<?>> bindings = new ConcurrentHashMap();

    @Override
    public <T> void registerServerbound(Class<T> type, class_2960 id, NetworkHelper.PacketEncoder<T> encoder, NetworkHelper.PacketDecoder<T> decoder, NetworkHelper.ServerboundHandler<T> handler) {
        this.bindings.put(type, new Binding<T>(id, encoder, Direction.SERVERBOUND));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (server, player, handlerAccessor, buf, responseSender) -> {
            Object message = decoder.decode(buf);
            server.execute(() -> handler.handle(message, player));
        });
    }

    @Override
    public <T> void registerClientbound(Class<T> type, class_2960 id, NetworkHelper.PacketEncoder<T> encoder, NetworkHelper.PacketDecoder<T> decoder, NetworkHelper.ClientboundHandler<T> handler) {
        this.bindings.put(type, new Binding<T>(id, encoder, Direction.CLIENTBOUND));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientAccess.register(id, decoder, handler);
        }
    }

    @Override
    public void sendToServer(Object message) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            throw new IllegalStateException("Client-only networking method invoked on a non-client environment");
        }
        Binding<Object> binding = this.bindingFor(message);
        if (binding.direction != Direction.SERVERBOUND) {
            throw new IllegalStateException("Attempted to send clientbound packet to server: " + String.valueOf(message.getClass()));
        }
        class_2540 buffer = this.createBuffer(binding, message);
        ClientAccess.send(binding.id, buffer);
    }

    @Override
    public void sendToPlayer(class_3222 player, Object message) {
        Binding<Object> binding = this.bindingFor(message);
        if (binding.direction != Direction.CLIENTBOUND) {
            throw new IllegalStateException("Attempted to send serverbound packet to player: " + String.valueOf(message.getClass()));
        }
        class_2540 buffer = this.createBuffer(binding, message);
        ServerPlayNetworking.send((class_3222)player, (class_2960)binding.id, (class_2540)buffer);
    }

    @Override
    public void sendToTracking(class_1297 entity, Object message) {
        Binding<Object> binding = this.bindingFor(message);
        if (binding.direction != Direction.CLIENTBOUND) {
            throw new IllegalStateException("Attempted to send serverbound packet to tracking players: " + String.valueOf(message.getClass()));
        }
        for (class_3222 tracking : PlayerLookup.tracking((class_1297)entity)) {
            class_2540 buffer = this.createBuffer(binding, message);
            ServerPlayNetworking.send((class_3222)tracking, (class_2960)binding.id, (class_2540)buffer);
        }
    }

    @Override
    public void sendToDimension(class_1937 level, Object message) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        Binding<Object> binding = this.bindingFor(message);
        if (binding.direction != Direction.CLIENTBOUND) {
            throw new IllegalStateException("Attempted to send serverbound packet to dimension: " + String.valueOf(message.getClass()));
        }
        for (class_3222 player : PlayerLookup.world((class_3218)serverLevel)) {
            class_2540 buffer = this.createBuffer(binding, message);
            ServerPlayNetworking.send((class_3222)player, (class_2960)binding.id, (class_2540)buffer);
        }
    }

    private Binding<Object> bindingFor(Object message) {
        Class<?> messageClass = message.getClass();
        Binding<Object> binding = this.bindings.get(messageClass);
        if (binding == null) {
            throw new IllegalStateException("No network binding registered for " + messageClass.getName());
        }
        return binding;
    }

    private class_2540 createBuffer(Binding<Object> binding, Object message) {
        class_2540 buffer = PacketByteBufs.create();
        NetworkHelper.PacketEncoder<Object> encoder = binding.encoder;
        encoder.encode(message, buffer);
        return buffer;
    }

    private static final class Binding<T> {
        final class_2960 id;
        final NetworkHelper.PacketEncoder<T> encoder;
        final Direction direction;

        Binding(class_2960 id, NetworkHelper.PacketEncoder<T> encoder, Direction direction) {
            this.id = id;
            this.encoder = encoder;
            this.direction = direction;
        }
    }

    private static enum Direction {
        SERVERBOUND,
        CLIENTBOUND;

    }

    @Environment(value=EnvType.CLIENT)
    private static final class ClientAccess {
        private ClientAccess() {
        }

        private static <T> void register(class_2960 id, NetworkHelper.PacketDecoder<T> decoder, NetworkHelper.ClientboundHandler<T> handler) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (client, handlerAccessor, buf, responseSender) -> {
                Object message = decoder.decode(buf);
                client.execute(() -> handler.handle(message));
            });
        }

        private static void send(class_2960 id, class_2540 buffer) {
            ClientPlayNetworking.send((class_2960)id, (class_2540)buffer);
        }
    }
}

