/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.fabric.server;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class FabricServerEvents {
    private FabricServerEvents() {
    }

    public static void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> server.execute(() -> FabricServerEvents.handlePlayerJoin(handler.field_14140)));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> server.execute(() -> FabricServerEvents.handlePlayerDisconnect(handler.field_14140)));
        ServerLifecycleEvents.SERVER_STOPPING.register(FabricServerEvents::handleServerStopping);
    }

    private static void handleServerStopping(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            FabricServerEvents.handlePlayerDisconnect(player);
        }
    }

    private static void handlePlayerJoin(class_3222 player) {
        RideableDragonBase dragon = FabricServerEvents.findMountedDragon(player);
        if (dragon == null) {
            return;
        }
        SaintsDragonsCommon.LOGGER.info("Restoring mounted dragon {} for player {}", (Object)dragon, (Object)player.method_7334().getName());
        dragon.method_5971();
        dragon.initializeAnimationState();
        dragon.resetAnimationState();
        dragon.tickAnimationStates();
        dragon.syncAnimState(dragon.getGroundMoveState(), dragon.getSyncedFlightMode());
        dragon.setAccelerating(false);
        dragon.setLastRiderForward(0.0f);
        dragon.setLastRiderStrafe(0.0f);
        if (dragon.method_24345()) {
            dragon.forceSitProgress(dragon.maxSitTicks());
        }
    }

    private static void handlePlayerDisconnect(class_3222 player) {
        RideableDragonBase dragon = FabricServerEvents.findMountedDragon(player);
        if (dragon == null) {
            return;
        }
        SaintsDragonsCommon.LOGGER.info("Preserving mounted dragon {} for player {} on disconnect", (Object)dragon, (Object)player.method_7334().getName());
        dragon.method_5971();
        dragon.method_5942().method_6340();
        dragon.setAccelerating(false);
        if (dragon.method_24345()) {
            dragon.forceSitProgress(dragon.maxSitTicks());
        }
    }

    private static RideableDragonBase findMountedDragon(class_3222 player) {
        if (player == null) {
            return null;
        }
        class_1297 vehicle = player.method_5854();
        if (vehicle instanceof RideableDragonBase) {
            RideableDragonBase rideable = (RideableDragonBase)vehicle;
            return rideable.method_31481() ? null : rideable;
        }
        class_1297 root = player.method_5668();
        if (root instanceof RideableDragonBase) {
            RideableDragonBase rideable = (RideableDragonBase)root;
            return rideable.method_31481() ? null : rideable;
        }
        return null;
    }
}

