/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.base;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public abstract class DragonSleepGoalBase
extends class_1352 {
    protected final DragonEntity dragon;
    protected final DragonSleepCapable sleepCapable;

    public DragonSleepGoalBase(DragonEntity dragon) {
        this.dragon = dragon;
        this.sleepCapable = (DragonSleepCapable)((Object)dragon);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        if (this.agitated()) {
            return false;
        }
        if (this.sleepCapable.isSleepSuppressed()) {
            return false;
        }
        if (!this.sleepCapable.canSleepNow()) {
            return false;
        }
        if (this.dragon.method_6181()) {
            return this.canTamedDragonSleep();
        }
        return this.canWildDragonSleep();
    }

    public boolean method_6266() {
        if (this.agitated()) {
            return false;
        }
        if (this.sleepCapable.isSleepSuppressed()) {
            return false;
        }
        if (this.dragon.method_6181()) {
            return this.canTamedDragonSleep();
        }
        DragonSleepCapable.SleepPreferences prefs = this.sleepCapable.getSleepPreferences();
        if (prefs.canSleepAtNight() && !prefs.canSleepDuringDay() && this.isDay()) {
            return false;
        }
        if (prefs.canSleepDuringDay() && !prefs.canSleepAtNight() && this.isNight()) {
            return false;
        }
        return this.canWildDragonSleep();
    }

    public void method_6269() {
        this.sleepCapable.startSleepEnter();
    }

    public void method_6270() {
        this.sleepCapable.startSleepExit();
    }

    protected boolean agitated() {
        if (this.dragon.method_5816() || this.dragon.method_5771()) {
            return true;
        }
        return this.dragon.method_29504() || this.dragon.method_5782() || this.dragon.method_5968() != null || this.dragon.method_6510();
    }

    protected boolean canTamedDragonSleep() {
        DragonSleepCapable.SleepPreferences prefs = this.sleepCapable.getSleepPreferences();
        if (prefs.avoidsThunderstorms() && this.dragon.method_37908().method_8546()) {
            return false;
        }
        if (this.ownerSleeping()) {
            return true;
        }
        return prefs.sleepsNearOwner() && this.isNight() && this.nearOwner();
    }

    protected boolean canWildDragonSleep() {
        DragonSleepCapable.SleepPreferences prefs = this.sleepCapable.getSleepPreferences();
        if (prefs.canSleepDuringDay() && this.isDay() && this.isSheltered()) {
            return !prefs.avoidsThunderstorms() || !this.dragon.method_37908().method_8546();
        }
        if (prefs.canSleepAtNight() && this.isNight() && this.isSheltered()) {
            return !prefs.avoidsThunderstorms() || !this.dragon.method_37908().method_8546();
        }
        return false;
    }

    protected boolean isDay() {
        return this.dragon.method_37908().method_8530();
    }

    protected boolean isNight() {
        return !this.dragon.method_37908().method_8530();
    }

    protected boolean ownerSleeping() {
        class_1657 p;
        class_1309 owner = this.dragon.method_35057();
        return owner instanceof class_1657 && (p = (class_1657)owner).method_6113();
    }

    protected boolean nearOwner() {
        class_1309 owner = this.dragon.method_35057();
        return owner != null && this.dragon.method_5858((class_1297)owner) <= 196.0;
    }

    protected boolean isSheltered() {
        class_2338 pos;
        class_1937 level = this.dragon.method_37908();
        boolean noSky = !level.method_8311(pos = this.dragon.method_24515());
        int light = level.method_22339(pos);
        return noSky || light < 7;
    }
}

