/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.cindervane;

import com.leon.saintsdragons.common.registry.cindervane.CindervaneAbilities;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class CindervaneCombatGoal
extends class_1352 {
    private final Cindervane amphithere;
    private final double attackRange = 4.5;
    private final double fireBodyActivationRange = 8.0;
    private final double chaseSpeed = 1.2;
    private int attackCooldown = 0;
    private int fireBodyCheckCooldown = 0;
    private int pathRecalcCooldown = 0;
    private double lastTargetX;
    private double lastTargetY;
    private double lastTargetZ;

    public CindervaneCombatGoal(Cindervane amphithere) {
        this.amphithere = amphithere;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        class_1309 target = this.amphithere.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.amphithere.method_5782() || this.amphithere.method_24345()) {
            return false;
        }
        return !(this.amphithere.method_5858((class_1297)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean method_6266() {
        class_1309 target = this.amphithere.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.amphithere.method_5782() || this.amphithere.method_24345()) {
            return false;
        }
        return !(this.amphithere.method_5858((class_1297)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6270() {
        this.amphithere.method_5942().method_6340();
        this.deactivateFireBodyIfActive();
        this.pathRecalcCooldown = 0;
    }

    public void method_6269() {
        class_1309 target = this.amphithere.method_5968();
        if (target != null) {
            this.amphithere.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            this.amphithere.method_5942().method_6335((class_1297)target, 1.2);
            this.rememberTargetPosition(target);
            double distanceSq = this.amphithere.method_5858((class_1297)target);
            if (distanceSq <= this.getAttackReachSqr(target)) {
                this.tryPerformBite(target);
            }
        }
    }

    public void method_6268() {
        class_1309 target;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.fireBodyCheckCooldown > 0) {
            --this.fireBodyCheckCooldown;
        }
        if ((target = this.amphithere.method_5968()) != null) {
            this.amphithere.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            double distanceSq = this.amphithere.method_5858((class_1297)target);
            double attackReachSq = this.getAttackReachSqr(target);
            boolean inAttackRange = distanceSq <= attackReachSq;
            boolean hasLineOfSight = this.amphithere.method_5985().method_6369((class_1297)target);
            if (!inAttackRange || !hasLineOfSight) {
                if (!this.isCurrentlyBiting()) {
                    this.updateChasePath(target);
                }
            } else {
                this.amphithere.method_5942().method_6340();
                this.pathRecalcCooldown = 0;
                this.tryPerformBite(target);
            }
            this.handleFireBodyActivation(target);
        } else {
            this.deactivateFireBodyIfActive();
        }
    }

    private boolean isCurrentlyBiting() {
        return this.amphithere.isAbilityActive(CindervaneAbilities.BITE);
    }

    private void tryPerformBite(class_1309 target) {
        if (this.attackCooldown > 0 || this.isCurrentlyBiting()) {
            return;
        }
        if (!this.amphithere.method_5985().method_6369((class_1297)target)) {
            return;
        }
        this.amphithere.combatManager.tryUseAbility(CindervaneAbilities.BITE);
        this.attackCooldown = 40;
    }

    private void handleFireBodyActivation(class_1309 target) {
        if (this.fireBodyCheckCooldown > 0) {
            return;
        }
        if (this.amphithere.method_5782()) {
            return;
        }
        if (this.amphithere.method_5816()) {
            return;
        }
        boolean fireBodyActive = this.amphithere.isAbilityActive(CindervaneAbilities.FIRE_BODY);
        double distanceToTarget = this.amphithere.method_5739((class_1297)target);
        if (!fireBodyActive && distanceToTarget < 8.0) {
            this.amphithere.combatManager.tryUseAbility(CindervaneAbilities.FIRE_BODY);
            this.fireBodyCheckCooldown = 40;
        } else if (fireBodyActive && distanceToTarget > 12.0) {
            this.amphithere.forceEndAbility(CindervaneAbilities.FIRE_BODY);
            this.fireBodyCheckCooldown = 40;
        }
    }

    private void deactivateFireBodyIfActive() {
        if (this.amphithere.method_5782()) {
            return;
        }
        if (this.amphithere.isAbilityActive(CindervaneAbilities.FIRE_BODY)) {
            this.amphithere.forceEndAbility(CindervaneAbilities.FIRE_BODY);
        }
    }

    private double getAttackReachSqr(class_1309 target) {
        double combinedRadii = (double)(this.amphithere.method_17681() + target.method_17681()) * 0.5;
        double reach = this.attackRange + combinedRadii;
        return reach * reach;
    }

    private double getMaxAggroDistanceSqr() {
        double followRange = this.amphithere.method_26825(class_5134.field_23717);
        if (followRange <= 0.0) {
            followRange = 16.0;
        }
        return followRange * followRange;
    }

    private void updateChasePath(class_1309 target) {
        if (--this.pathRecalcCooldown <= 0 || this.targetMovedSignificantly(target)) {
            this.rememberTargetPosition(target);
            double distance = this.amphithere.method_5739((class_1297)target);
            this.pathRecalcCooldown = class_3532.method_15340((int)((int)(distance * 0.6)), (int)5, (int)20);
            this.amphithere.method_5942().method_6335((class_1297)target, 1.2);
        }
    }

    private void rememberTargetPosition(class_1309 target) {
        this.lastTargetX = target.method_23317();
        this.lastTargetY = target.method_23318();
        this.lastTargetZ = target.method_23321();
    }

    private boolean targetMovedSignificantly(class_1309 target) {
        double dz;
        double dy;
        double dx = target.method_23317() - this.lastTargetX;
        return dx * dx + (dy = target.method_23318() - this.lastTargetY) * dy + (dz = target.method_23321() - this.lastTargetZ) * dz > 4.0;
    }
}

