/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.cindervane;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class CindervaneFlightGoal
extends class_1352 {
    private final Cindervane amphithere;
    private class_243 targetPosition;
    private int stuckCounter = 0;
    private int timeSinceTargetChange = 0;
    private static final int LANDING_COOLDOWN_TICKS = 40;
    private long lastLandingTime = 0L;
    private int flightDecisionCooldown = 0;
    private boolean wasThundering = false;
    private boolean wasRaining = false;

    public CindervaneFlightGoal(Cindervane amphithere) {
        this.amphithere = amphithere;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.flightDecisionCooldown = 0;
    }

    public boolean method_6264() {
        boolean isFlying;
        if (this.amphithere.isLanding()) {
            return false;
        }
        if (this.amphithere.method_5782() || this.amphithere.method_5765() || this.amphithere.method_24345()) {
            return false;
        }
        if (this.amphithere.method_6181() && this.amphithere.method_35057() != null && !this.isOverDanger()) {
            return false;
        }
        boolean thundering = this.amphithere.method_37908().method_8546();
        boolean raining = !thundering && this.amphithere.method_37908().method_8419();
        boolean weatherChangedToStorm = thundering && !this.wasThundering || raining && !this.wasRaining;
        boolean weatherChangedToThunder = thundering && !this.wasThundering;
        this.wasThundering = thundering;
        this.wasRaining = raining;
        long currentTime = this.amphithere.method_37908().method_8510();
        int cooldown = 40;
        if (thundering) {
            cooldown = 0;
        } else if (raining) {
            cooldown /= 4;
        }
        if (weatherChangedToStorm) {
            cooldown = 0;
        }
        if (!this.amphithere.method_6581() && currentTime - this.lastLandingTime < (long)cooldown) {
            return false;
        }
        int decisionInterval = this.flightDecisionInterval(thundering, raining);
        if (this.flightDecisionCooldown > 0) {
            --this.flightDecisionCooldown;
            if (this.flightDecisionCooldown > 0) {
                if (weatherChangedToThunder) {
                    this.flightDecisionCooldown = 0;
                } else if ((thundering || raining) && this.flightDecisionCooldown > decisionInterval) {
                    this.flightDecisionCooldown = decisionInterval;
                }
                if (this.flightDecisionCooldown > 0) {
                    return false;
                }
            }
        }
        if (isFlying = this.isOverDanger() ? true : (this.amphithere.method_6581() ? this.shouldKeepFlying(thundering, raining) : this.shouldTakeOff(thundering, raining))) {
            this.targetPosition = this.findFlightTarget();
            this.flightDecisionCooldown = this.nextDecisionCooldown(decisionInterval);
            return true;
        }
        this.flightDecisionCooldown = this.nextDecisionCooldown(decisionInterval);
        return false;
    }

    public boolean method_6266() {
        if (this.amphithere.isLanding()) {
            return false;
        }
        if (this.amphithere.method_24345() || this.amphithere.method_5782()) {
            return false;
        }
        if (this.amphithere.method_6181() && this.amphithere.method_35057() != null && !this.isOverDanger()) {
            this.amphithere.setGoingUp(false);
            this.amphithere.setGoingDown(false);
            this.amphithere.setLanding(true);
            this.amphithere.setFlying(false);
            this.amphithere.setHovering(false);
            this.amphithere.setTakeoff(false);
            return false;
        }
        class_1309 target = this.amphithere.method_5968();
        if (target != null && target.method_5805()) {
            return false;
        }
        if (!this.amphithere.method_6181()) {
            boolean raining;
            boolean thundering = this.amphithere.method_37908().method_8546();
            boolean bl = raining = !thundering && this.amphithere.method_37908().method_8419();
            if (this.amphithere.method_6581() && !this.shouldKeepFlying(thundering, raining)) {
                this.amphithere.setLanding(true);
                this.amphithere.setFlying(false);
                this.amphithere.setTakeoff(false);
                this.amphithere.setHovering(false);
                return false;
            }
        }
        if (this.amphithere.method_6581() && this.amphithere.method_24828() && this.timeSinceTargetChange > 5) {
            return false;
        }
        return this.amphithere.method_6581() && this.targetPosition != null && this.amphithere.method_5707(this.targetPosition) > 9.0;
    }

    public void method_6269() {
        this.amphithere.setFlying(true);
        this.amphithere.setLanding(false);
        this.amphithere.setHovering(false);
        if (this.targetPosition != null) {
            this.amphithere.method_5962().method_6239(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, (double)this.amphithere.getFlightSpeed());
        }
    }

    public void method_6268() {
        ++this.timeSinceTargetChange;
        if (this.amphithere.isLanding()) {
            return;
        }
        if (this.amphithere.method_6581() && this.amphithere.method_24828() && this.timeSinceTargetChange > 5) {
            this.amphithere.setLanding(true);
            this.amphithere.setFlying(false);
            this.amphithere.setTakeoff(false);
            this.amphithere.setHovering(false);
            this.amphithere.markLandedNow();
            return;
        }
        if (this.amphithere.method_6181() && this.amphithere.method_35057() != null && !this.isOverDanger()) {
            this.amphithere.setLanding(true);
            this.amphithere.setFlying(false);
            this.amphithere.setHovering(false);
            this.amphithere.setTakeoff(false);
            return;
        }
        boolean needNewTarget = false;
        if (this.targetPosition == null) {
            needNewTarget = true;
        } else {
            double distanceToTarget = this.amphithere.method_5707(this.targetPosition);
            if (distanceToTarget < 100.0) {
                needNewTarget = true;
            }
            if (this.amphithere.field_5976 && distanceToTarget > 25.0) {
                needNewTarget = true;
                this.stuckCounter = 0;
            }
            if (this.amphithere.field_5976 && this.timeSinceTargetChange % 5 == 0) {
                ++this.stuckCounter;
                if (this.stuckCounter > 2) {
                    needNewTarget = true;
                    this.stuckCounter = 0;
                }
            } else if (!this.amphithere.field_5976) {
                this.stuckCounter = Math.max(0, this.stuckCounter - 1);
            }
            if (this.amphithere.field_6012 % 20 == 0 && !this.isValidFlightTarget(this.targetPosition)) {
                needNewTarget = true;
            }
            if (this.timeSinceTargetChange > 300) {
                needNewTarget = true;
            }
        }
        if (needNewTarget) {
            this.targetPosition = this.findFlightTarget();
            this.timeSinceTargetChange = 0;
            this.amphithere.method_5962().method_6239(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, (double)this.amphithere.getFlightSpeed());
        }
    }

    public void method_6270() {
        this.targetPosition = null;
        this.stuckCounter = 0;
        this.timeSinceTargetChange = 0;
        this.amphithere.method_5942().method_6340();
        if (!this.amphithere.method_6581()) {
            this.lastLandingTime = this.amphithere.method_37908().method_8510();
        }
    }

    private class_243 findFlightTarget() {
        class_243 dragonPos = this.amphithere.method_19538();
        class_243 anchor = this.getFlightAnchor();
        for (int attempts = 0; attempts < 16; ++attempts) {
            class_243 candidate = this.generateFlightCandidate(anchor, dragonPos, attempts);
            if (!this.isValidFlightTarget(candidate)) continue;
            return candidate;
        }
        return new class_243(anchor.field_1352, this.findSafeFlightHeight(anchor.field_1352, anchor.field_1350, true), anchor.field_1350);
    }

    private class_243 generateFlightCandidate(class_243 anchor, class_243 dragonPos, int attempt) {
        class_243 candidate;
        boolean isStuck = this.amphithere.field_5976 || this.stuckCounter > 0;
        boolean tethered = this.isTamedWander();
        if (tethered) {
            double min = 10.0 + this.amphithere.method_6051().method_43058() * 6.0;
            double max = 24.0 + this.amphithere.method_6051().method_43058() * 6.0;
            double angle = this.amphithere.method_6051().method_43058() * Math.PI * 2.0;
            double radius = min + this.amphithere.method_6051().method_43058() * (max - min);
            double cx = anchor.field_1352 + Math.cos(angle) * radius;
            double cz = anchor.field_1350 + Math.sin(angle) * radius;
            double targetY = this.findSafeFlightHeight(cx, cz, true);
            candidate = new class_243(cx, targetY, cz);
        } else {
            float maxRot = isStuck ? 360.0f : 180.0f;
            float range = isStuck ? 40.0f + this.amphithere.method_6051().method_43057() * 60.0f : 80.0f + this.amphithere.method_6051().method_43057() * 120.0f;
            float yRotOffset = isStuck && attempt < 8 ? (float)Math.toRadians(180.0f + this.amphithere.method_6051().method_43057() * 120.0f - 60.0f) : (float)Math.toRadians(this.amphithere.method_6051().method_43057() * maxRot - maxRot / 2.0f);
            float xRotOffset = (float)Math.toRadians((this.amphithere.method_6051().method_43057() - 0.5f) * 20.0f);
            class_243 lookVec = this.amphithere.method_5720();
            class_243 targetVec = lookVec.method_1021((double)range).method_1024(yRotOffset).method_1037(xRotOffset);
            class_243 raw = dragonPos.method_1019(targetVec);
            double targetY = this.findSafeFlightHeight(raw.field_1352, raw.field_1350, false);
            candidate = new class_243(raw.field_1352, targetY, raw.field_1350);
        }
        if (!this.amphithere.method_37908().method_8477(class_2338.method_49638((class_2374)candidate))) {
            return null;
        }
        return candidate;
    }

    private double findSafeFlightHeight(double x, double z, boolean tethered) {
        boolean raining;
        int ix = (int)x;
        int iz = (int)z;
        int groundY = this.amphithere.method_37908().method_8624(class_2902.class_2903.field_13203, ix, iz);
        double base = tethered ? 12.0 + this.amphithere.method_6051().method_43058() * 12.0 : 25.0 + this.amphithere.method_6051().method_43058() * 35.0;
        boolean thundering = this.amphithere.method_37908().method_8546();
        boolean bl = raining = !thundering && this.amphithere.method_37908().method_8419();
        double capAboveGround = tethered ? (thundering ? 12.0 : (raining ? 18.0 : 32.0)) : (thundering ? 20.0 : (raining ? 30.0 : 80.0));
        double target = (double)groundY + base;
        double cap = (double)groundY + capAboveGround;
        double worldCap = (double)this.amphithere.method_37908().method_31600() - 10.0;
        return Math.min(Math.min(target, cap), worldCap);
    }

    private class_243 getFlightAnchor() {
        class_1309 owner;
        if (this.isTamedWander() && (owner = this.amphithere.method_35057()) != null) {
            return owner.method_19538();
        }
        return this.amphithere.method_19538();
    }

    private boolean isTamedWander() {
        return this.amphithere.method_6181() && this.amphithere.getCommand() == 2 && this.amphithere.method_35057() != null;
    }

    private boolean isValidFlightTarget(class_243 target) {
        double distanceToTarget;
        if (target == null) {
            return false;
        }
        class_3965 result = this.amphithere.method_37908().method_17742(new class_3959(this.amphithere.method_33571(), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.amphithere));
        if (result.method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        double distanceToHit = result.method_17784().method_1022(this.amphithere.method_19538());
        return distanceToHit > (distanceToTarget = target.method_1022(this.amphithere.method_19538())) * 0.95;
    }

    private int flightDecisionInterval(boolean thundering, boolean raining) {
        if (thundering) {
            return 2;
        }
        if (raining) {
            return 5;
        }
        return 8;
    }

    private int nextDecisionCooldown(int baseInterval) {
        int jitter = Math.max(1, baseInterval / 2);
        return baseInterval + this.amphithere.method_6051().method_43048(jitter);
    }

    private boolean shouldTakeOff(boolean thundering, boolean raining) {
        if (this.isOverDanger()) {
            return true;
        }
        if (!this.amphithere.method_6181()) {
            boolean isNight;
            long dayTime = this.amphithere.method_37908().method_8532() % 24000L;
            boolean bl = isNight = dayTime >= 13000L && dayTime < 23000L;
            if (isNight) {
                return false;
            }
        }
        if (thundering) {
            return this.amphithere.method_6051().method_43048(200) == 0;
        }
        if (raining) {
            return this.amphithere.method_6051().method_43048(100) == 0;
        }
        return this.amphithere.method_6051().method_43048(40) == 0;
    }

    private boolean shouldKeepFlying(boolean thundering, boolean raining) {
        if (this.isOverDanger()) {
            return true;
        }
        if (!this.amphithere.method_6181()) {
            boolean isNight;
            long dayTime = this.amphithere.method_37908().method_8532() % 24000L;
            boolean bl = isNight = dayTime >= 13000L && dayTime < 23000L;
            if (isNight) {
                return this.amphithere.method_6051().method_43048(100) != 0;
            }
        }
        if (thundering) {
            return this.amphithere.method_6051().method_43048(200) != 0;
        }
        if (raining) {
            return this.amphithere.method_6051().method_43048(400) != 0;
        }
        return this.amphithere.method_6051().method_43048(3600) != 0;
    }

    private boolean isOverDanger() {
        class_2338 dragonPos = this.amphithere.method_24515();
        boolean foundSolid = false;
        boolean nearFluid = false;
        for (int i = 1; i <= 25; ++i) {
            class_2338 checkPos = dragonPos.method_10087(i);
            class_2680 state = this.amphithere.method_37908().method_8320(checkPos);
            if (!state.method_26220((class_1922)this.amphithere.method_37908(), checkPos).method_1110() || state.method_26206((class_1922)this.amphithere.method_37908(), checkPos, class_2350.field_11036)) {
                foundSolid = true;
                break;
            }
            if (i > 10 || this.amphithere.method_37908().method_8316(checkPos).method_15769()) continue;
            nearFluid = true;
        }
        if (nearFluid) {
            return true;
        }
        return !foundSolid && dragonPos.method_10264() < this.amphithere.method_37908().method_31607() + 20;
    }
}

