/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.cindervane;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class CindervaneFollowOwnerGoal
extends class_1352 {
    private final Cindervane amphithere;
    private static final double START_FOLLOW_DIST = 8.8;
    private static final double STOP_FOLLOW_DIST = 8.0;
    private static final double TELEPORT_DIST = 500.0;
    private static final double RUN_DIST = 10.0;
    private static final double FLIGHT_TRIGGER_DIST = 24.0;
    private static final double FLIGHT_HEIGHT_DIFF = 6.0;
    private static final double LANDING_DISTANCE = 10.0;
    private static final double HOVER_HEIGHT = 2.5;
    private int pathRecalcCooldown;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public CindervaneFollowOwnerGoal(Cindervane dragon) {
        this.amphithere = dragon;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.amphithere.method_6181() || this.amphithere.method_24345()) {
            return false;
        }
        if (this.amphithere.isSittingDownAnimation()) {
            return false;
        }
        if (this.amphithere.getCommand() == 1) {
            return false;
        }
        if (this.amphithere.method_5968() != null && this.amphithere.method_5968().method_5805()) {
            return false;
        }
        class_1309 owner = this.amphithere.method_35057();
        if (owner == null || !owner.method_5805()) {
            return false;
        }
        if (owner.method_37908() != this.amphithere.method_37908()) {
            return false;
        }
        double distSq = this.amphithere.method_5858((class_1297)owner);
        return distSq > 77.44000000000001;
    }

    public boolean method_6266() {
        class_1309 owner = this.amphithere.method_35057();
        if (owner == null || !owner.method_5805()) {
            return false;
        }
        if (this.amphithere.method_24345() || this.amphithere.isSittingDownAnimation() || this.amphithere.getCommand() == 1) {
            return false;
        }
        if (this.amphithere.method_5968() != null && this.amphithere.method_5968().method_5805()) {
            return false;
        }
        if (owner.method_37908() != this.amphithere.method_37908()) {
            return false;
        }
        double distSq = this.amphithere.method_5858((class_1297)owner);
        return distSq > 64.0;
    }

    public void method_6269() {
        this.resetPathTracking();
    }

    public void method_6270() {
        this.amphithere.setRunning(false);
        this.amphithere.method_5942().method_6340();
        this.amphithere.setGroundMoveStateFromAI(0);
        this.resetPathTracking();
    }

    public void method_6268() {
        class_1309 owner = this.amphithere.method_35057();
        if (owner == null) {
            return;
        }
        double distance = this.amphithere.method_5739((class_1297)owner);
        if (distance > 500.0) {
            this.amphithere.method_5859(owner.method_23317(), owner.method_23318() + 2.0, owner.method_23321());
            this.amphithere.setFlying(true);
            this.amphithere.setTakeoff(false);
            this.amphithere.setLanding(false);
            this.amphithere.setHovering(false);
            this.resetPathTracking();
            return;
        }
        this.amphithere.method_5988().method_6226((class_1297)owner, 10.0f, 10.0f);
        boolean shouldFly = this.shouldTriggerFlight(owner, distance);
        if (shouldFly && !this.amphithere.method_6581()) {
            this.amphithere.setFlying(true);
            this.amphithere.setTakeoff(true);
            this.amphithere.setLanding(false);
            this.amphithere.setHovering(false);
            this.resetPathTracking();
        } else if (this.amphithere.method_6581() && distance < 12.0) {
            this.amphithere.setLanding(true);
            this.amphithere.setFlying(false);
            this.amphithere.setHovering(false);
            this.amphithere.setTakeoff(false);
            this.pathRecalcCooldown = 0;
        }
        if (this.amphithere.method_6581()) {
            this.handleFlightFollowing(owner);
        } else {
            this.handleGroundFollowing(owner, distance);
        }
    }

    private void handleFlightFollowing(class_1309 owner) {
        double targetZ;
        double targetY = owner.method_23318() + (double)owner.method_17682() + 2.5;
        class_243 ownerLook = owner.method_5720();
        double offsetX = -ownerLook.field_1352 * 2.5;
        double offsetZ = -ownerLook.field_1350 * 2.5;
        double verticalOffset = Math.sin((double)this.amphithere.field_6012 * 0.2) * 0.25;
        double targetX = owner.method_23317() + offsetX;
        double distanceToTargetSq = this.amphithere.method_5649(targetX, targetY, targetZ = owner.method_23321() + offsetZ);
        if (distanceToTargetSq > 1.0) {
            this.amphithere.method_5962().method_6239(targetX, targetY + verticalOffset, targetZ, (double)this.amphithere.getFlightSpeed());
        } else {
            this.amphithere.method_5942().method_6340();
        }
    }

    private void handleGroundFollowing(class_1309 owner, double distance) {
        if (distance <= 8.0) {
            if (this.amphithere.getGroundMoveState() > 0) {
                this.amphithere.method_5942().method_6340();
                this.amphithere.setRunning(false);
                this.amphithere.setGroundMoveStateFromAI(0);
            }
            this.pathRecalcCooldown = 0;
            return;
        }
        boolean shouldRun = distance > 10.0;
        this.amphithere.setRunning(shouldRun);
        int moveState = shouldRun ? 2 : 1;
        this.amphithere.setGroundMoveStateFromAI(moveState);
        double baseSpeed = shouldRun ? 1.1 : 0.7;
        double speed = baseSpeed * (1.0 + distance / 40.0);
        speed = Math.min(speed, shouldRun ? 1.6 : 1.0);
        this.updateGroundPath(owner, speed, distance, shouldRun);
        if (this.amphithere.method_5942().method_31267()) {
            this.amphithere.method_5993().method_6233();
            this.amphithere.method_5942().method_6340();
            this.pathRecalcCooldown = 0;
        }
    }

    private boolean shouldTriggerFlight(class_1309 owner, double distance) {
        if (this.amphithere.method_6581()) {
            return !(distance < 10.0) || !(owner.method_23318() - this.amphithere.method_23318() < 6.0);
        }
        if (this.amphithere.isHovering() || !this.canTriggerFlight()) {
            return false;
        }
        if (distance < 12.0) {
            return false;
        }
        boolean farAway = distance > 24.0;
        boolean ownerAbove = owner.method_23318() - this.amphithere.method_23318() > 6.0;
        return farAway || ownerAbove;
    }

    private boolean canTriggerFlight() {
        return !this.amphithere.method_24345() && !this.amphithere.method_6109() && (this.amphithere.method_24828() || this.amphithere.method_5799()) && this.amphithere.method_5685().isEmpty() && this.amphithere.method_5642() == null && !this.amphithere.method_5765();
    }

    private void updateGroundPath(class_1309 owner, double speed, double distance, boolean running) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.amphithere.method_5942().method_6357() || !this.amphithere.method_5942().method_23966();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            if (!this.amphithere.method_5942().method_6335((class_1297)owner, speed)) {
                this.amphithere.method_5942().method_6337(owner.method_23317(), owner.method_23318(), owner.method_23321(), speed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance, running);
        }
    }

    private int computeRepathCooldown(double distance, boolean running) {
        int base = (int)Math.ceil(distance * (running ? 0.35 : 0.45));
        return class_3532.method_15340((int)base, (int)(running ? 4 : 6), (int)(running ? 16 : 22));
    }

    private void rememberOwnerPosition(class_1309 owner) {
        this.lastOwnerX = owner.method_23317();
        this.lastOwnerY = owner.method_23318();
        this.lastOwnerZ = owner.method_23321();
    }

    private boolean ownerMovedSignificantly(class_1309 owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.method_23317() - this.lastOwnerX;
        return dx * dx + (dy = owner.method_23318() - this.lastOwnerY) * dy + (dz = owner.method_23321() - this.lastOwnerZ) * dz > 1.2;
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }
}

