/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.common.registry.nulljaw.NulljawAbilities;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_5134;

public class NulljawCombatGoal
extends class_1352 {
    private static final double CHASE_SPEED = 1.5;
    private static final double BITE_RANGE = 3.5;
    private static final double HORN_RANGE = 4.5;
    private static final int MIN_ATTACK_COOLDOWN_TICKS = 10;
    private final Nulljaw drake;
    private int attackCooldown;

    public NulljawCombatGoal(Nulljaw drake) {
        this.drake = drake;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.drake.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.drake.method_5782() || this.drake.method_24345()) {
            return false;
        }
        return this.isWithinAggroRange(target);
    }

    public boolean method_6266() {
        class_1309 target = this.drake.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.drake.method_5782() || this.drake.method_24345()) {
            return false;
        }
        return this.isWithinAggroRange(target);
    }

    public void method_6269() {
        this.attackCooldown = 0;
        this.drake.method_19540(true);
        class_1309 target = this.drake.method_5968();
        if (target != null) {
            this.drake.method_5942().method_6335((class_1297)target, 1.5);
        }
    }

    public void method_6270() {
        this.drake.method_5942().method_6340();
        this.drake.method_19540(false);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 target;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if ((target = this.drake.method_5968()) == null) {
            return;
        }
        this.drake.method_5988().method_6226((class_1297)target, 35.0f, 35.0f);
        double distanceSq = this.drake.method_5858((class_1297)target);
        double attackReachSq = this.getAttackReachSqr(target);
        boolean inRange = distanceSq <= attackReachSq;
        boolean hasLineOfSight = this.drake.method_5985().method_6369((class_1297)target);
        if (!inRange || !hasLineOfSight) {
            if (!this.isPerformingAttack()) {
                this.drake.method_5942().method_6335((class_1297)target, 1.5);
            }
            return;
        }
        this.drake.method_5942().method_6340();
        this.tryPerformAttacks(target);
    }

    private void tryPerformAttacks(class_1309 target) {
        if (this.attackCooldown > 0) {
            return;
        }
        DragonAbilityType<Nulljaw, ?> ability = this.choosePrimaryAttack(target);
        if (ability != null && this.drake.combatManager.canStart(ability)) {
            this.drake.combatManager.tryUseAbility(ability);
            this.attackCooldown = 10;
        }
    }

    private DragonAbilityType<Nulljaw, ?> choosePrimaryAttack(class_1309 target) {
        double gap = this.getGapToTarget(target);
        boolean phaseTwo = this.drake.isPhaseTwoActive();
        if (gap <= 3.5) {
            if (phaseTwo && this.drake.method_6051().method_43056()) {
                return NulljawAbilities.NULLJAW_CLAW;
            }
            return phaseTwo ? NulljawAbilities.NULLJAW_BITE2 : NulljawAbilities.NULLJAW_BITE;
        }
        if (gap <= 4.5) {
            if (phaseTwo && this.drake.method_6051().method_43056()) {
                return NulljawAbilities.NULLJAW_CLAW;
            }
            return NulljawAbilities.NULLJAW_HORN_GORE;
        }
        return null;
    }

    private boolean isPerformingAttack() {
        return this.drake.getActiveAbility() != null || this.drake.combatManager.isAbilityActive(NulljawAbilities.NULLJAW_CLAW);
    }

    private boolean isWithinAggroRange(class_1309 target) {
        double followRange = this.drake.method_26825(class_5134.field_23717);
        if (followRange <= 0.0) {
            followRange = 16.0;
        }
        double maxDistanceSq = followRange * followRange;
        return this.drake.method_5858((class_1297)target) <= maxDistanceSq;
    }

    private double getAttackReachSqr(class_1309 target) {
        double combinedRadii = (double)(this.drake.method_17681() + target.method_17681()) * 0.5;
        double reach = 4.5 + combinedRadii;
        return reach * reach;
    }

    private double getGapToTarget(class_1309 target) {
        double distance = this.drake.method_5739((class_1297)target);
        double combinedRadii = (double)(this.drake.method_17681() + target.method_17681()) * 0.5;
        return Math.max(0.0, distance - combinedRadii);
    }
}

