/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3532;

public class NulljawFollowOwnerGoal
extends class_1352 {
    private static final double START_DISTANCE = 7.0;
    private static final double STOP_DISTANCE = 7.0;
    private static final double RUN_DISTANCE = 9.0;
    private static final double TELEPORT_DISTANCE = 64.0;
    private final Nulljaw drake;
    private int pathRecalcCooldown;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public NulljawFollowOwnerGoal(Nulljaw drake) {
        this.drake = drake;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.drake.method_6181() || this.drake.method_24345() || this.drake.method_5782()) {
            return false;
        }
        class_1309 owner = this.drake.method_35057();
        if (owner == null || !owner.method_5805() || owner.method_37908() != this.drake.method_37908()) {
            return false;
        }
        if (this.drake.method_5968() != null) {
            return false;
        }
        return this.drake.method_5858((class_1297)owner) > 49.0;
    }

    public boolean method_6266() {
        if (!this.drake.method_6181() || this.drake.method_24345() || this.drake.method_5782()) {
            return false;
        }
        class_1309 owner = this.drake.method_35057();
        if (owner == null || !owner.method_5805() || owner.method_37908() != this.drake.method_37908()) {
            return false;
        }
        if (this.drake.method_5968() != null) {
            return false;
        }
        return this.drake.method_5858((class_1297)owner) > 49.0;
    }

    public void method_6269() {
        this.resetPathTracking();
        this.drake.setAccelerating(false);
    }

    public void method_6270() {
        this.drake.method_5942().method_6340();
        this.drake.setAccelerating(false);
        this.resetPathTracking();
    }

    public void method_6268() {
        class_1309 owner = this.drake.method_35057();
        if (owner == null) {
            return;
        }
        double distance = this.drake.method_5739((class_1297)owner);
        if (distance > 64.0) {
            this.drake.method_5859(owner.method_23317(), owner.method_23318(), owner.method_23321());
            this.drake.method_5942().method_6340();
            this.drake.setAccelerating(false);
            this.resetPathTracking();
            return;
        }
        this.drake.method_5988().method_6226((class_1297)owner, 10.0f, (float)this.drake.method_5978());
        if (distance <= 7.0) {
            this.drake.method_5942().method_6340();
            this.drake.setAccelerating(false);
            return;
        }
        boolean shouldRun = distance > 9.0;
        this.drake.setAccelerating(shouldRun);
        double speed = shouldRun ? 1.35 : 0.85;
        this.updateGroundPath(owner, speed, distance, shouldRun);
    }

    private void updateGroundPath(class_1309 owner, double speed, double distance, boolean running) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.drake.method_5942().method_6357() || !this.drake.method_5942().method_23966();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            double effectiveSpeed;
            double d = effectiveSpeed = this.drake.method_5799() ? speed * 1.3 : speed;
            if (!this.drake.method_5942().method_6335((class_1297)owner, effectiveSpeed)) {
                this.drake.method_5942().method_6337(owner.method_23317(), owner.method_23318(), owner.method_23321(), effectiveSpeed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance, running);
        }
    }

    private int computeRepathCooldown(double distance, boolean running) {
        int base = (int)Math.ceil(distance * (running ? 0.4 : 0.55));
        return class_3532.method_15340((int)base, (int)(running ? 4 : 6), (int)(running ? 16 : 24));
    }

    private void rememberOwnerPosition(class_1309 owner) {
        this.lastOwnerX = owner.method_23317();
        this.lastOwnerY = owner.method_23318();
        this.lastOwnerZ = owner.method_23321();
    }

    private boolean ownerMovedSignificantly(class_1309 owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.method_23317() - this.lastOwnerX;
        return dx * dx + (dy = owner.method_23318() - this.lastOwnerY) * dy + (dz = owner.method_23321() - this.lastOwnerZ) * dz > 1.0;
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }
}

