/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.EnumSet;
import net.minecraft.class_1352;

public class NulljawRestGoal
extends class_1352 {
    private final Nulljaw drake;
    private int retryCooldown;
    private static final int SIT_PAUSE = 20;
    private static final int SLEEP_MIN = 80;
    private static final int SLEEP_MAX = 160;
    private static final int WAKE_PAUSE = 20;
    private static final int RETRY_COOLDOWN_MIN = 200;
    private static final int RETRY_COOLDOWN_MAX = 400;

    public NulljawRestGoal(Nulljaw drake) {
        this.drake = drake;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.drake.getRestManager().isResting()) {
            return true;
        }
        if (this.drake.method_6181()) {
            return false;
        }
        if (this.drake.isSleepLocked()) {
            return false;
        }
        if (this.drake.method_5816() || this.drake.method_5771()) {
            return false;
        }
        if (this.drake.isDying() || this.drake.method_5782()) {
            return false;
        }
        if (this.drake.method_5968() != null || this.drake.method_6510()) {
            return false;
        }
        if (this.drake.method_5681()) {
            return false;
        }
        if (this.drake.getActiveAbility() != null) {
            return false;
        }
        return this.drake.method_6051().method_43057() < 5.0E-4f;
    }

    public boolean method_6266() {
        boolean safeToRest = !this.drake.method_5816() && this.drake.method_5968() == null && !this.drake.method_6510();
        return this.drake.getRestManager().isResting() && safeToRest;
    }

    public void method_6269() {
        DragonRestManager restManager = this.drake.getRestManager();
        if (restManager.isResting()) {
            return;
        }
        int sleepDuration = 80 + this.drake.method_6051().method_43048(80);
        restManager.startRest(sleepDuration);
        this.drake.method_24346(true);
        this.drake.method_5942().method_6340();
    }

    public void method_6268() {
        if (this.drake.method_37908().field_9236) {
            return;
        }
        DragonRestManager restManager = this.drake.getRestManager();
        DragonRestState state = restManager.getCurrentState();
        this.drake.method_5942().method_6340();
        this.drake.method_18800(0.0, this.drake.method_18798().field_1351, 0.0);
        if (!(state != DragonRestState.SITTING_DOWN && state != DragonRestState.SITTING || this.drake.method_24345())) {
            this.drake.method_24346(true);
        }
        switch (state) {
            case SITTING_DOWN: {
                if (restManager.getStateTimer() <= 38 || this.drake.isInSitTransition()) break;
                restManager.advanceState();
                break;
            }
            case SITTING: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                this.drake.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.drake.method_6113() || this.drake.isSleepTransitioning()) && restManager.getStateTimer() <= 55) break;
                restManager.advanceState();
                break;
            }
            case SLEEPING: {
                restManager.incrementRestingTicks();
                if (restManager.getRestingTicks() < restManager.getRestDuration()) break;
                restManager.advanceState();
                this.drake.startSleepExit();
                this.drake.method_24346(true);
                break;
            }
            case WAKING_UP: {
                if (restManager.getStateTimer() <= 45) break;
                restManager.advanceState();
                this.drake.method_24346(true);
                break;
            }
            case SITTING_AFTER: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                this.drake.method_24346(false);
                break;
            }
            case STANDING_UP: {
                if (restManager.getStateTimer() <= 45) break;
                restManager.advanceState();
                break;
            }
        }
        restManager.tick();
    }

    public void method_6270() {
        DragonRestManager restManager = this.drake.getRestManager();
        if (restManager.isResting() && restManager.getCurrentState() != DragonRestState.STANDING_UP) {
            if (this.drake.method_6113() || this.drake.isSleepTransitioning()) {
                this.drake.startSleepExit();
            }
            this.drake.method_24346(false);
            restManager.stopRest();
        }
        this.retryCooldown = 200 + this.drake.method_6051().method_43048(200);
    }

    public boolean method_6267() {
        return true;
    }
}

