/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.common.registry.raevyx.RaevyxAbilities;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class RaevyxCombatGoal
extends class_1352 {
    private final Raevyx wyvern;
    private final double biteRange = 3.0;
    private final double goreRange = 4.5;
    private final double chaseSpeed = 1.4;
    private int attackCooldown = 0;
    private int pathRecalcCooldown = 0;
    private double lastTargetX;
    private double lastTargetY;
    private double lastTargetZ;

    public RaevyxCombatGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        class_1309 target = this.wyvern.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.wyvern.method_5782() || this.wyvern.method_24345()) {
            return false;
        }
        return !(this.wyvern.method_5858((class_1297)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean method_6266() {
        class_1309 target = this.wyvern.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (this.wyvern.method_5782() || this.wyvern.method_24345()) {
            return false;
        }
        return !(this.wyvern.method_5858((class_1297)target) > this.getMaxAggroDistanceSqr());
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6270() {
        this.wyvern.method_5942().method_6340();
        this.wyvern.setRunning(false);
        this.wyvern.method_19540(false);
        this.pathRecalcCooldown = 0;
    }

    public void method_6269() {
        this.wyvern.setRunning(true);
        this.wyvern.method_19540(true);
        class_1309 target = this.wyvern.method_5968();
        if (target != null) {
            this.wyvern.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            this.wyvern.method_5942().method_6335((class_1297)target, 1.4);
            this.rememberTargetPosition(target);
            this.tryAttack(target);
        }
    }

    public void method_6268() {
        class_1309 target;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if ((target = this.wyvern.method_5968()) != null) {
            this.wyvern.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            double gap = this.getGapToTarget(target);
            boolean hasLineOfSight = this.wyvern.method_5985().method_6369((class_1297)target);
            if (gap > 4.5 || !hasLineOfSight) {
                if (!this.isCurrentlyAttacking()) {
                    this.updateChasePath(target);
                }
            } else {
                this.wyvern.method_5942().method_6340();
                this.pathRecalcCooldown = 0;
                this.tryAttack(target);
            }
        }
    }

    private boolean isCurrentlyAttacking() {
        return this.wyvern.isAbilityActive(RaevyxAbilities.RAEVYX_BITE) || this.wyvern.isAbilityActive(RaevyxAbilities.RAEVYX_HORN_GORE);
    }

    private void tryAttack(class_1309 target) {
        if (this.attackCooldown > 0 || this.isCurrentlyAttacking()) {
            return;
        }
        if (!this.wyvern.method_5985().method_6369((class_1297)target)) {
            return;
        }
        double gap = this.getGapToTarget(target);
        if (gap <= 3.0) {
            this.wyvern.combatManager.tryUseAbility(RaevyxAbilities.RAEVYX_BITE);
            this.attackCooldown = 20;
        } else if (gap <= 4.5) {
            this.wyvern.combatManager.tryUseAbility(RaevyxAbilities.RAEVYX_HORN_GORE);
            this.attackCooldown = 20;
        }
    }

    private double getGapToTarget(class_1309 target) {
        double centerDistance = this.wyvern.method_5739((class_1297)target);
        double combinedRadii = (double)(this.wyvern.method_17681() + target.method_17681()) * 0.5;
        return Math.max(0.0, centerDistance - combinedRadii);
    }

    private double getMaxAggroDistanceSqr() {
        double followRange = this.wyvern.method_26825(class_5134.field_23717);
        if (followRange <= 0.0) {
            followRange = 32.0;
        }
        return followRange * followRange;
    }

    private void updateChasePath(class_1309 target) {
        if (--this.pathRecalcCooldown <= 0 || this.targetMovedSignificantly(target)) {
            this.rememberTargetPosition(target);
            double distance = this.wyvern.method_5739((class_1297)target);
            this.pathRecalcCooldown = class_3532.method_15340((int)((int)(distance * 0.6)), (int)5, (int)20);
            this.wyvern.method_5942().method_6335((class_1297)target, 1.4);
        }
    }

    private void rememberTargetPosition(class_1309 target) {
        this.lastTargetX = target.method_23317();
        this.lastTargetY = target.method_23318();
        this.lastTargetZ = target.method_23321();
    }

    private boolean targetMovedSignificantly(class_1309 target) {
        double dz;
        double dy;
        double dx = target.method_23317() - this.lastTargetX;
        return dx * dx + (dy = target.method_23318() - this.lastTargetY) * dy + (dz = target.method_23321() - this.lastTargetZ) * dz > 4.0;
    }
}

