/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.util.DragonMathUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1676;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3959;

public class RaevyxDodgeGoal
extends class_1352 {
    private final Raevyx wyvern;
    private static final double SCAN_RADIUS_H = 32.0;
    private static final double SCAN_RADIUS_V = 22.0;
    private static final int SCAN_INTERVAL = 2;
    private static final int DODGE_TICKS = 9;
    private static final int COOLDOWN = 8;
    private static final double DOT_THREAT = 0.65;
    private static final double MIN_SPEED2 = 0.0015;
    private static final double DODGE_LAT_IMPULSE = 0.8;
    private static final double DODGE_UP_IMPULSE = 0.4;
    private long nextScanTime = 0L;
    private long nextAllowedDodgeTime = 0L;

    private List<class_1676> getCachedThreats() {
        return this.wyvern.getCachedNearbyProjectiles().stream().filter(p -> p.method_5805() && p.method_24921() != this.wyvern && p.method_24921() != this.wyvern.method_35057() && p.method_18798().method_1027() > 0.0015).collect(Collectors.toList());
    }

    public RaevyxDodgeGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        Object mostThreatening;
        if (!this.wyvern.method_5805()) {
            return false;
        }
        if (this.wyvern.method_6181() && this.wyvern.method_5782()) {
            return false;
        }
        if (this.wyvern.isDodging()) {
            return false;
        }
        if (!this.wyvern.method_6581()) {
            return false;
        }
        long now = this.wyvern.method_37908().method_8510();
        if (now < this.nextScanTime) {
            return false;
        }
        this.nextScanTime = now + 2L;
        if (now < this.nextAllowedDodgeTime) {
            return false;
        }
        List<Object> threats = this.getCachedThreats().stream().filter(p -> DragonMathUtil.hasLineOfSight((class_1309)this.wyvern, (class_1297)p)).collect(Collectors.toList());
        if (threats.isEmpty()) {
            threats = this.getCachedThreats();
        }
        if ((mostThreatening = this.mostMovingTowardMeFromList(threats, (class_1309)this.wyvern)) == null) {
            return false;
        }
        class_243 dv = new class_243(mostThreatening.method_23317() - ((class_1676)mostThreatening).field_6014, mostThreatening.method_23318() - ((class_1676)mostThreatening).field_6036, mostThreatening.method_23321() - ((class_1676)mostThreatening).field_5969);
        if (dv.method_1027() < 0.0015) {
            return false;
        }
        class_243 dodgeDirection = DragonMathUtil.calculateDodgeDirection((class_1297)this.wyvern, mostThreatening);
        if (dodgeDirection.equals((Object)class_243.field_1353)) {
            return false;
        }
        class_243 dodgeVec = new class_243(dodgeDirection.field_1352 * 0.8, 0.4, dodgeDirection.field_1350 * 0.8);
        dodgeVec = DragonMathUtil.clampVectorLength(dodgeVec, 1.5);
        this.wyvern.beginDodge(dodgeVec, 9);
        this.nextAllowedDodgeTime = now + 8L;
        return true;
    }

    public void method_6269() {
        this.wyvern.method_5942().method_6340();
        this.wyvern.triggerDodgeAnimation();
        this.wyvern.playAnnoyedSound();
    }

    public boolean method_6266() {
        return false;
    }

    public void method_6270() {
    }

    private class_243 guessProjectileDestination(class_1676 projectile) {
        class_243 from = projectile.method_19538();
        class_243 vel = projectile.method_18798();
        if (vel.method_1027() < 1.0E-6) {
            return from;
        }
        class_243 to = from.method_1019(vel.method_1021(50.0));
        return projectile.method_37908().method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)projectile)).method_17784();
    }

    @Nullable
    private <T extends class_1676> T mostMovingTowardMe(Class<? extends T> cls, Predicate<? super T> pred, class_1309 me, class_238 box) {
        return this.mostMovingTowardMeFromList(me.method_37908().method_8390(cls, box, pred), me);
    }

    private <T extends class_1676> T mostMovingTowardMeFromList(List<? extends T> entities, class_1309 me) {
        double best = 0.65;
        class_1676 bestEnt = null;
        for (class_1676 p : entities) {
            double dot;
            class_243 dv = new class_243(p.method_23317() - p.field_6014, p.method_23318() - p.field_6036, p.method_23321() - p.field_5969);
            double ls = dv.method_1027();
            if (ls < 0.0015 || !((dot = dv.method_1029().method_1026(me.method_19538().method_1020(p.method_19538()).method_1029())) > best)) continue;
            best = dot;
            bestEnt = p;
        }
        return (T)bestEnt;
    }
}

