/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class RaevyxFlightGoal
extends class_1352 {
    private final Raevyx wyvern;
    private class_243 targetPosition;
    private int stuckCounter = 0;
    private int timeSinceTargetChange = 0;
    private static final int LANDING_COOLDOWN_TICKS = 100;
    private long lastLandingTime = 0L;
    private int flightDecisionCooldown = 0;
    private boolean wasThundering = false;
    private boolean wasRaining = false;

    public RaevyxFlightGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.flightDecisionCooldown = 0;
    }

    public boolean method_6264() {
        boolean isFlying;
        class_1309 owner;
        if (this.wyvern.isLanding()) {
            return false;
        }
        if (this.wyvern.method_5782() || this.wyvern.method_5765() || this.wyvern.method_24345()) {
            return false;
        }
        if (!this.wyvern.method_6109() && this.hasNearbyBabies() && !this.isOverDanger()) {
            return false;
        }
        boolean thundering = this.wyvern.method_37908().method_8546();
        boolean raining = !thundering && this.wyvern.method_37908().method_8419();
        boolean stormy = thundering || raining;
        boolean weatherChangedToStorm = thundering && !this.wasThundering || raining && !this.wasRaining;
        boolean weatherChangedToThunder = thundering && !this.wasThundering;
        this.wasThundering = thundering;
        this.wasRaining = raining;
        if (this.wyvern.method_6181() && (owner = this.wyvern.method_35057()) != null && this.wyvern.method_5858((class_1297)owner) < 225.0 && !this.isOverDanger()) {
            return false;
        }
        long currentTime = this.wyvern.method_37908().method_8510();
        int cooldown = 100;
        if (thundering) {
            cooldown = 0;
        } else if (raining) {
            cooldown /= 4;
        }
        if (weatherChangedToStorm) {
            cooldown = 0;
        }
        if (!this.wyvern.method_6581() && currentTime - this.lastLandingTime < (long)cooldown) {
            return false;
        }
        int decisionInterval = this.flightDecisionInterval(thundering, raining);
        if (this.flightDecisionCooldown > 0) {
            --this.flightDecisionCooldown;
            if (this.flightDecisionCooldown > 0) {
                if (weatherChangedToThunder) {
                    this.flightDecisionCooldown = 0;
                } else if ((thundering || raining) && this.flightDecisionCooldown > decisionInterval) {
                    this.flightDecisionCooldown = decisionInterval;
                }
                if (this.flightDecisionCooldown > 0) {
                    return false;
                }
            }
        }
        if (isFlying = this.isOverDanger() ? true : (this.wyvern.method_6581() ? this.shouldKeepFlying(thundering, raining) : this.shouldTakeOff(thundering, raining))) {
            this.targetPosition = this.findFlightTarget();
            this.flightDecisionCooldown = this.nextDecisionCooldown(decisionInterval);
            return true;
        }
        this.flightDecisionCooldown = this.nextDecisionCooldown(decisionInterval);
        return false;
    }

    public boolean method_6266() {
        boolean raining;
        if (this.wyvern.isLanding()) {
            return false;
        }
        if (this.wyvern.method_24345() || this.wyvern.method_5782()) {
            return false;
        }
        if (this.wyvern.method_5968() != null && this.wyvern.method_5968().method_5805()) {
            return false;
        }
        boolean thundering = this.wyvern.method_37908().method_8546();
        boolean bl = raining = !thundering && this.wyvern.method_37908().method_8419();
        if (this.wyvern.method_6581() && !this.shouldKeepFlying(thundering, raining)) {
            this.wyvern.setLanding(true);
            this.wyvern.setFlying(false);
            this.wyvern.setTakeoff(false);
            this.wyvern.setHovering(false);
            return false;
        }
        return this.wyvern.method_6581() && this.targetPosition != null && this.wyvern.method_5707(this.targetPosition) > 9.0;
    }

    public void method_6269() {
        this.wyvern.setFlying(true);
        this.wyvern.setTakeoff(false);
        this.wyvern.setLanding(false);
        this.wyvern.setHovering(false);
        if (this.targetPosition != null) {
            this.wyvern.method_5962().method_6239(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, 1.0);
        }
    }

    public void method_6268() {
        ++this.timeSinceTargetChange;
        if (this.wyvern.isLanding()) {
            return;
        }
        boolean needNewTarget = false;
        if (this.targetPosition == null) {
            needNewTarget = true;
        } else {
            double distanceToTarget = this.wyvern.method_5707(this.targetPosition);
            if (distanceToTarget < 64.0) {
                needNewTarget = true;
            }
            if (this.wyvern.isFlightControllerStuck() && distanceToTarget > 25.0) {
                needNewTarget = true;
                this.stuckCounter = 0;
            }
            if (this.wyvern.field_5976 && this.timeSinceTargetChange % 5 == 0) {
                ++this.stuckCounter;
                if (this.stuckCounter > 2) {
                    needNewTarget = true;
                    this.stuckCounter = 0;
                }
            } else if (!this.wyvern.field_5976) {
                this.stuckCounter = Math.max(0, this.stuckCounter - 1);
            }
            if (this.wyvern.field_6012 % 20 == 0 && !this.isValidFlightTarget(this.targetPosition)) {
                needNewTarget = true;
            }
            if (this.timeSinceTargetChange > 300) {
                needNewTarget = true;
            }
        }
        if (needNewTarget) {
            this.targetPosition = this.findFlightTarget();
            this.timeSinceTargetChange = 0;
            this.wyvern.method_5962().method_6239(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, 1.0);
        }
    }

    public void method_6270() {
        this.targetPosition = null;
        this.stuckCounter = 0;
        this.timeSinceTargetChange = 0;
        this.wyvern.method_5942().method_6340();
        if (!this.wyvern.method_6581()) {
            this.lastLandingTime = this.wyvern.method_37908().method_8510();
        }
    }

    private class_243 findFlightTarget() {
        class_243 dragonPos = this.wyvern.method_19538();
        for (int attempts = 0; attempts < 16; ++attempts) {
            class_243 candidate = this.generateFlightCandidate(dragonPos, attempts);
            if (!this.isValidFlightTarget(candidate)) continue;
            return candidate;
        }
        return new class_243(dragonPos.field_1352, this.findSafeFlightHeight(dragonPos.field_1352, dragonPos.field_1350), dragonPos.field_1350);
    }

    private class_243 generateFlightCandidate(class_243 dragonPos, int attempt) {
        boolean isStuck = this.wyvern.field_5976 || this.stuckCounter > 0 || this.wyvern.isFlightControllerStuck();
        float maxRot = isStuck ? 360.0f : 180.0f;
        float range = isStuck ? 30.0f + this.wyvern.method_6051().method_43057() * 40.0f : 50.0f + this.wyvern.method_6051().method_43057() * 80.0f;
        float yRotOffset = isStuck && attempt < 8 ? (float)Math.toRadians(180.0f + this.wyvern.method_6051().method_43057() * 120.0f - 60.0f) : (float)Math.toRadians(this.wyvern.method_6051().method_43057() * maxRot - maxRot / 2.0f);
        float xRotOffset = (float)Math.toRadians((this.wyvern.method_6051().method_43057() - 0.5f) * 20.0f);
        class_243 lookVec = this.wyvern.method_5720();
        class_243 targetVec = lookVec.method_1021((double)range).method_1024(yRotOffset).method_1037(xRotOffset);
        class_243 candidate = dragonPos.method_1019(targetVec);
        double targetY = this.findSafeFlightHeight(candidate.field_1352, candidate.field_1350);
        candidate = new class_243(candidate.field_1352, targetY, candidate.field_1350);
        if (!this.wyvern.method_37908().method_8477(class_2338.method_49638((class_2374)candidate))) {
            return null;
        }
        return candidate;
    }

    private double findSafeFlightHeight(double x, double z) {
        boolean raining;
        int ix = (int)x;
        int iz = (int)z;
        int groundY = this.wyvern.method_37908().method_8624(class_2902.class_2903.field_13203, ix, iz);
        double base = 15.0 + this.wyvern.method_6051().method_43058() * 20.0;
        boolean thundering = this.wyvern.method_37908().method_8546();
        boolean bl = raining = !thundering && this.wyvern.method_37908().method_8419();
        double capAboveGround = thundering ? 90.0 : (raining ? 70.0 : 50.0);
        double target = (double)groundY + base;
        double cap = (double)groundY + capAboveGround;
        double worldCap = (double)this.wyvern.method_37908().method_31600() - 10.0;
        return Math.min(Math.min(target, cap), worldCap);
    }

    private boolean isValidFlightTarget(class_243 target) {
        double distanceToTarget;
        if (target == null) {
            return false;
        }
        class_3965 result = this.wyvern.method_37908().method_17742(new class_3959(this.wyvern.method_33571(), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.wyvern));
        if (result.method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        double distanceToHit = result.method_17784().method_1022(this.wyvern.method_19538());
        return distanceToHit > (distanceToTarget = target.method_1022(this.wyvern.method_19538())) * 0.95;
    }

    private int flightDecisionInterval(boolean thundering, boolean raining) {
        if (thundering) {
            return 2;
        }
        if (raining) {
            return 8;
        }
        return 25;
    }

    private int nextDecisionCooldown(int baseInterval) {
        int jitter = Math.max(1, baseInterval / 2);
        return baseInterval + this.wyvern.method_6051().method_43048(jitter);
    }

    private boolean shouldTakeOff(boolean thundering, boolean raining) {
        if (this.isOverDanger()) {
            return true;
        }
        if (thundering) {
            return this.wyvern.method_6051().method_43048(4) == 0;
        }
        if (raining) {
            return this.wyvern.method_6051().method_43048(8) == 0;
        }
        return this.wyvern.method_6051().method_43048(80) == 0;
    }

    private boolean shouldKeepFlying(boolean thundering, boolean raining) {
        if (this.isOverDanger()) {
            return true;
        }
        if (thundering) {
            return this.wyvern.method_6051().method_43048(3000) != 0;
        }
        if (raining) {
            return this.wyvern.method_6051().method_43048(1800) != 0;
        }
        return this.wyvern.method_6051().method_43048(200) != 0;
    }

    private boolean hasNearbyBabies() {
        return !this.wyvern.method_37908().method_8390(Raevyx.class, this.wyvern.method_5829().method_1014(16.0), baby -> baby != null && baby.method_6109() && baby.method_5805()).isEmpty();
    }

    private boolean isOverDanger() {
        class_2338 dragonPos = this.wyvern.method_24515();
        boolean foundSolid = false;
        boolean nearFluid = false;
        for (int i = 1; i <= 25; ++i) {
            class_2338 checkPos = dragonPos.method_10087(i);
            class_2680 state = this.wyvern.method_37908().method_8320(checkPos);
            if (!state.method_26220((class_1922)this.wyvern.method_37908(), checkPos).method_1110() || state.method_26206((class_1922)this.wyvern.method_37908(), checkPos, class_2350.field_11036)) {
                foundSolid = true;
                break;
            }
            if (i > 10 || this.wyvern.method_37908().method_8316(checkPos).method_15769()) continue;
            nearFluid = true;
        }
        if (nearFluid) {
            return true;
        }
        return !foundSolid && dragonPos.method_10264() < this.wyvern.method_37908().method_31607() + 20;
    }
}

