/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class RaevyxFollowOwnerGoal
extends class_1352 {
    private final Raevyx wyvern;
    private static final double START_FOLLOW_DIST = 5.0;
    private static final double STOP_FOLLOW_DIST = 5.0;
    private static final double TELEPORT_DIST = 500.0;
    private static final double RUN_DIST = 15.0;
    private static final double FLIGHT_TRIGGER_DIST = 20.0;
    private static final double FLIGHT_HEIGHT_DIFF = 8.0;
    private static final double LANDING_DISTANCE = 12.0;
    private static final double HOVER_HEIGHT = 3.0;
    private int pathRecalcCooldown = 0;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public RaevyxFollowOwnerGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.wyvern.method_6181() || this.wyvern.method_24345() || this.wyvern.isSleepLocked()) {
            return false;
        }
        if (this.wyvern.method_5968() != null && this.wyvern.method_5968().method_5805()) {
            return false;
        }
        class_1309 owner = this.wyvern.method_35057();
        if (owner == null || !owner.method_5805()) {
            return false;
        }
        if (owner.method_37908() != this.wyvern.method_37908()) {
            return false;
        }
        double ownerDist = this.wyvern.getCachedDistanceToOwner();
        return ownerDist > 25.0;
    }

    public boolean method_6266() {
        class_1309 owner = this.wyvern.method_35057();
        if (owner == null || !owner.method_5805() || this.wyvern.method_24345() || this.wyvern.isSleepLocked()) {
            return false;
        }
        if (this.wyvern.method_5968() != null && this.wyvern.method_5968().method_5805()) {
            return false;
        }
        if (owner.method_37908() != this.wyvern.method_37908()) {
            return false;
        }
        double dist = this.wyvern.method_5858((class_1297)owner);
        return dist > 25.0;
    }

    public void method_6269() {
        this.resetPathTracking();
        class_1309 owner = this.wyvern.method_35057();
        double dist = owner != null ? Math.sqrt(this.wyvern.method_5858((class_1297)owner)) : -1.0;
    }

    public void method_6268() {
        class_1309 owner = this.wyvern.method_35057();
        if (owner == null) {
            return;
        }
        double distance = this.wyvern.method_5739((class_1297)owner);
        if (distance > 500.0) {
            this.wyvern.method_5859(owner.method_23317(), owner.method_23318() + 3.0, owner.method_23321());
            this.wyvern.setFlying(true);
            this.wyvern.setTakeoff(false);
            this.wyvern.setLanding(false);
            this.wyvern.setHovering(false);
            this.resetPathTracking();
            return;
        }
        this.wyvern.method_5988().method_6226((class_1297)owner, 10.0f, 10.0f);
        boolean shouldFly = this.shouldTriggerFlight(owner, distance);
        if (shouldFly && !this.wyvern.method_6581()) {
            this.wyvern.setFlying(true);
            this.wyvern.setTakeoff(true);
            this.wyvern.setLanding(false);
            this.wyvern.setHovering(false);
            this.resetPathTracking();
        } else if (this.wyvern.method_6581() && distance < 7.5) {
            this.wyvern.setLanding(true);
            this.wyvern.setFlying(false);
            this.wyvern.setHovering(true);
            this.pathRecalcCooldown = 0;
        }
        if (this.wyvern.method_6581()) {
            this.handleFlightFollowing(owner);
        } else {
            this.handleGroundFollowing(owner, distance);
        }
    }

    private void handleFlightFollowing(class_1309 owner) {
        double targetZ;
        double targetY = owner.method_23318() + (double)owner.method_17682() + 3.0;
        class_243 ownerLook = owner.method_5720();
        double offsetX = -ownerLook.field_1352 * 3.0;
        double offsetZ = -ownerLook.field_1350 * 3.0;
        double verticalOffset = Math.sin((double)this.wyvern.field_6012 * 0.2) * 0.3;
        double targetX = owner.method_23317() + offsetX;
        double distanceToTarget = Math.sqrt(this.wyvern.method_5649(targetX, targetY, targetZ = owner.method_23321() + offsetZ));
        if (distanceToTarget > 1.0) {
            this.wyvern.method_5962().method_6239(targetX, targetY + verticalOffset, targetZ, 1.2);
        } else {
            this.wyvern.method_5942().method_6340();
        }
    }

    private void handleGroundFollowing(class_1309 owner, double distance) {
        if (distance <= 5.0) {
            if (this.wyvern.getGroundMoveState() > 0) {
                this.wyvern.method_5942().method_6340();
                this.wyvern.setRunning(false);
                this.wyvern.setGroundMoveStateFromAI(0);
            }
            this.pathRecalcCooldown = 0;
            return;
        }
        boolean shouldRun = distance > 15.0;
        this.wyvern.setRunning(shouldRun);
        int moveState = shouldRun ? 2 : 1;
        this.wyvern.setGroundMoveStateFromAI(moveState);
        double baseSpeed = shouldRun ? 1.5 : 0.8;
        double speed = baseSpeed * (1.0 + distance / 50.0);
        speed = Math.min(speed, shouldRun ? 2.5 : 1.2);
        this.updateGroundPath(owner, speed, distance, shouldRun);
        if (this.wyvern.method_5942().method_31267()) {
            this.wyvern.method_5993().method_6233();
            this.wyvern.method_5942().method_6340();
            this.pathRecalcCooldown = 0;
        }
    }

    private boolean shouldTriggerFlight(class_1309 owner, double distance) {
        if (this.wyvern.method_6581()) {
            return !(distance < 12.0) || !(owner.method_23318() - this.wyvern.method_23318() < 8.0);
        }
        if (this.wyvern.isHovering() || !this.canTriggerFlight()) {
            return false;
        }
        if (distance < 7.5) {
            return false;
        }
        boolean farAway = distance > 20.0;
        boolean ownerAbove = owner.method_23318() - this.wyvern.method_23318() > 8.0;
        return farAway || ownerAbove;
    }

    private boolean canTriggerFlight() {
        return !this.wyvern.method_24345() && !this.wyvern.method_6109() && (this.wyvern.method_24828() || this.wyvern.method_5799()) && this.wyvern.method_5685().isEmpty() && this.wyvern.method_5642() == null && !this.wyvern.method_5765() && this.wyvern.getActiveAbility() == null;
    }

    public void method_6270() {
        this.wyvern.setRunning(false);
        this.wyvern.method_5942().method_6340();
        this.wyvern.setGroundMoveStateFromAI(0);
        this.resetPathTracking();
    }

    private void updateGroundPath(class_1309 owner, double speed, double distance, boolean running) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.wyvern.method_5942().method_6357() || !this.wyvern.method_5942().method_23966();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            if (!this.wyvern.method_5942().method_6335((class_1297)owner, speed)) {
                this.wyvern.method_5942().method_6337(owner.method_23317(), owner.method_23318(), owner.method_23321(), speed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance, running);
        }
    }

    private int computeRepathCooldown(double distance, boolean running) {
        int base = (int)Math.ceil(distance * (running ? 0.3 : 0.45));
        return class_3532.method_15340((int)base, (int)(running ? 4 : 6), (int)(running ? 18 : 24));
    }

    private boolean ownerMovedSignificantly(class_1309 owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.method_23317() - this.lastOwnerX;
        return dx * dx + (dy = owner.method_23318() - this.lastOwnerY) * dy + (dz = owner.method_23321() - this.lastOwnerZ) * dz > 1.2;
    }

    private void rememberOwnerPosition(class_1309 owner) {
        this.lastOwnerX = owner.method_23317();
        this.lastOwnerY = owner.method_23318();
        this.lastOwnerZ = owner.method_23321();
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }
}

