/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class RaevyxTemptGoal
extends class_1352 {
    private final Raevyx dragon;
    private final double speedModifier;
    private final class_1856 items;
    private final boolean canScare;
    private int consumptionCooldown = 0;
    private class_1542 targetFish = null;

    public RaevyxTemptGoal(Raevyx dragon, double speedModifier, class_1856 items, boolean canScare) {
        this.dragon = dragon;
        this.speedModifier = speedModifier;
        this.items = items;
        this.canScare = canScare;
    }

    public boolean method_6264() {
        if (this.dragon.method_6113() || this.dragon.isDying() || this.dragon.method_5782()) {
            return false;
        }
        return this.findNearestFish() != null;
    }

    private class_1542 findNearestFish() {
        class_238 broadphase = this.dragon.method_5829().method_1009(12.0, 12.0, 12.0);
        List nearbyItems = this.dragon.method_37908().method_8390(class_1542.class, broadphase, item -> this.dragon.method_6481(item.method_6983()));
        if (nearbyItems.isEmpty()) {
            return null;
        }
        return nearbyItems.stream().min((i1, i2) -> Double.compare(this.dragon.method_5858((class_1297)i1), this.dragon.method_5858((class_1297)i2))).orElse(null);
    }

    public void method_6269() {
        this.targetFish = this.findNearestFish();
        if (this.targetFish != null) {
            this.dragon.method_5942().method_6335((class_1297)this.targetFish, this.speedModifier);
        }
    }

    public void method_6270() {
        this.targetFish = null;
        this.dragon.method_5942().method_6340();
    }

    public boolean method_6266() {
        if (this.targetFish == null || !this.targetFish.method_5805()) {
            return false;
        }
        return !(this.dragon.method_5858((class_1297)this.targetFish) > 144.0);
    }

    public void method_6268() {
        double distance;
        if (this.consumptionCooldown > 0) {
            --this.consumptionCooldown;
        }
        if (!this.dragon.method_37908().field_9236 && this.consumptionCooldown <= 0 && this.targetFish != null && (distance = this.dragon.method_5858((class_1297)this.targetFish)) <= 2.25) {
            this.handleFishConsumption(this.targetFish);
            this.consumptionCooldown = 20;
            this.targetFish = null;
        }
    }

    private void handleFishConsumption(class_1542 fishItem) {
        if (fishItem == null || !fishItem.method_5805()) {
            return;
        }
        class_1657 feedingPlayer = this.findNearestPlayer();
        fishItem.method_31472();
        this.dragon.triggerAnim("action", "eat");
        this.dragon.method_5783(ModSounds.RAEVYX_CHUFF.get(), 1.0f, 1.0f + this.dragon.method_6051().method_43057() * 0.3f);
        if (this.dragon.method_6181()) {
            float healAmount = 10.0f;
            float oldHealth = this.dragon.method_6032();
            float newHealth = Math.min(oldHealth + healAmount, this.dragon.method_6063());
            this.dragon.method_6033(newHealth);
            this.dragon.method_37908().method_8421((class_1297)this.dragon, (byte)7);
            this.sendFeedingMessage(feedingPlayer, newHealth);
        } else if (feedingPlayer != null && this.dragon.method_6051().method_43048(10) == 0) {
            this.dragon.method_6170(feedingPlayer);
            this.dragon.method_24346(true);
            this.dragon.setCommandManual(1);
            this.dragon.method_37908().method_8421((class_1297)this.dragon, (byte)7);
            if (feedingPlayer instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)feedingPlayer;
                class_161 advancement = serverPlayer.field_13995.method_3851().method_12896(SaintsDragonsCommon.rl("tame_lightning_dragon"));
                if (advancement != null) {
                    serverPlayer.method_14236().method_12878(advancement, "tame_lightning_dragon");
                }
            }
        } else {
            this.dragon.method_37908().method_8421((class_1297)this.dragon, (byte)6);
        }
    }

    private class_1657 findNearestPlayer() {
        List nearbyPlayers = this.dragon.method_37908().method_8390(class_1657.class, this.dragon.method_5829().method_1014(10.0), player -> player.method_5805() && !player.method_7325());
        if (nearbyPlayers.isEmpty()) {
            return null;
        }
        return nearbyPlayers.stream().min((p1, p2) -> Double.compare(this.dragon.method_5858((class_1297)p1), this.dragon.method_5858((class_1297)p2))).orElse(null);
    }

    private void sendFeedingMessage(class_1657 player, float newHealth) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            String messageKey = newHealth >= this.dragon.method_6063() ? "entity.saintsdragons.raevyx.fed" : "entity.saintsdragons.raevyx.fed_partial";
            serverPlayer.method_7353((class_2561)class_2561.method_43469((String)messageKey, (Object[])new Object[]{this.dragon.method_5477()}), true);
        }
    }
}

