/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.stegonaut;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_243;
import net.minecraft.class_5532;

public class StegonautFleeFromPredatorsGoal
extends class_1352 {
    private final Stegonaut stegonaut;
    private final double fleeSpeed;
    private final double detectionRange;
    private class_1309 threatEntity;
    private class_11 fleePath;
    private int fleeTimer;
    private static final int FLEE_DURATION = 100;
    private static final double MIN_FLEE_DISTANCE = 16.0;

    public StegonautFleeFromPredatorsGoal(Stegonaut stegonaut, double fleeSpeed, double detectionRange) {
        this.stegonaut = stegonaut;
        this.fleeSpeed = fleeSpeed;
        this.detectionRange = detectionRange;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.stegonaut.method_6113() || this.stegonaut.isDying() || this.stegonaut.method_5816()) {
            return false;
        }
        if (this.stegonaut.method_24345()) {
            return false;
        }
        List nearbyEntities = this.stegonaut.method_37908().method_8390(class_1309.class, this.stegonaut.method_5829().method_1014(this.detectionRange), entity -> entity.method_5805() && this.isThreateningEntity((class_1309)entity));
        if (nearbyEntities.isEmpty()) {
            return false;
        }
        class_1309 closestThreat = null;
        double closestDistSq = Double.MAX_VALUE;
        for (class_1309 entity2 : nearbyEntities) {
            double distSq = this.stegonaut.method_5858((class_1297)entity2);
            if (!(distSq < closestDistSq)) continue;
            closestDistSq = distSq;
            closestThreat = entity2;
        }
        if (closestThreat == null) {
            return false;
        }
        class_243 fleePos = class_5532.method_31511((class_1314)this.stegonaut, (int)16, (int)7, (class_243)closestThreat.method_19538());
        if (fleePos == null) {
            return false;
        }
        if (closestThreat.method_5649(fleePos.field_1352, fleePos.field_1351, fleePos.field_1350) < closestDistSq) {
            return false;
        }
        class_1408 navigation = this.stegonaut.method_5942();
        class_11 path = navigation.method_6352(fleePos.field_1352, fleePos.field_1351, fleePos.field_1350, 0);
        if (path == null || !path.method_21655()) {
            return false;
        }
        this.threatEntity = closestThreat;
        this.fleePath = path;
        return true;
    }

    public boolean method_6266() {
        if (this.stegonaut.method_6113() || this.stegonaut.method_5816()) {
            return false;
        }
        if (this.threatEntity != null && this.stegonaut.method_5858((class_1297)this.threatEntity) > 256.0) {
            return false;
        }
        if (this.threatEntity == null || !this.threatEntity.method_5805() || this.threatEntity.method_31481()) {
            return false;
        }
        return this.fleeTimer <= 100;
    }

    public void method_6269() {
        if (this.fleePath != null) {
            this.stegonaut.method_5942().method_6334(this.fleePath, this.fleeSpeed);
        }
        this.fleeTimer = 0;
    }

    public void method_6270() {
        this.threatEntity = null;
        this.fleePath = null;
        this.fleeTimer = 0;
        this.stegonaut.method_5942().method_6340();
    }

    public void method_6268() {
        class_243 fleePos;
        ++this.fleeTimer;
        if (this.threatEntity != null && this.threatEntity.method_5805() && this.fleeTimer % 20 == 0 && (fleePos = class_5532.method_31511((class_1314)this.stegonaut, (int)16, (int)7, (class_243)this.threatEntity.method_19538())) != null) {
            this.stegonaut.method_5942().method_6337(fleePos.field_1352, fleePos.field_1351, fleePos.field_1350, this.fleeSpeed);
        }
    }

    private boolean isThreateningEntity(class_1309 entity) {
        if (entity instanceof Raevyx) {
            Raevyx raevyx = (Raevyx)entity;
            if (this.stegonaut.method_6181()) {
                return !raevyx.method_6181();
            }
            return true;
        }
        if (entity instanceof Stegonaut) {
            Stegonaut otherStegonaut = (Stegonaut)entity;
            if (otherStegonaut == this.stegonaut) {
                return false;
            }
            return !this.stegonaut.method_6181() || !otherStegonaut.method_6181();
        }
        return false;
    }
}

