/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.stegonaut;

import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3532;

public class StegonautFollowOwnerGoal
extends class_1352 {
    private final Stegonaut drake;
    private static final double START_FOLLOW_DIST = 12.0;
    private static final double STOP_FOLLOW_DIST = 8.0;
    private static final double TELEPORT_DIST = 2000.0;
    private int pathRecalcCooldown = 0;
    private double lastOwnerX = Double.NaN;
    private double lastOwnerY = Double.NaN;
    private double lastOwnerZ = Double.NaN;

    public StegonautFollowOwnerGoal(Stegonaut drake) {
        this.drake = drake;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.drake.method_6181() || this.drake.method_24345()) {
            return false;
        }
        class_1309 target = this.drake.method_5968();
        if (target != null && target.method_5805()) {
            return false;
        }
        class_1309 owner = this.drake.method_35057();
        if (owner == null || !owner.method_5805()) {
            return false;
        }
        if (owner.method_37908() != this.drake.method_37908()) {
            return false;
        }
        double ownerDist = this.drake.method_5858((class_1297)owner);
        return ownerDist > 144.0;
    }

    public boolean method_6266() {
        class_1309 owner = this.drake.method_35057();
        if (owner == null || !owner.method_5805() || this.drake.method_24345()) {
            return false;
        }
        class_1309 target = this.drake.method_5968();
        if (target != null && target.method_5805()) {
            return false;
        }
        if (owner.method_37908() != this.drake.method_37908()) {
            return false;
        }
        double dist = this.drake.method_5858((class_1297)owner);
        return dist > 64.0;
    }

    public void method_6269() {
        this.resetPathTracking();
    }

    public void method_6268() {
        class_1309 owner = this.drake.method_35057();
        if (owner == null) {
            return;
        }
        double distance = this.drake.method_5739((class_1297)owner);
        if (distance > 2000.0) {
            this.drake.method_5859(owner.method_23317(), owner.method_23318() + 1.0, owner.method_23321());
            this.resetPathTracking();
            return;
        }
        this.drake.method_5988().method_6226((class_1297)owner, 10.0f, 10.0f);
        this.handleGroundFollowing(owner, distance);
    }

    private void handleGroundFollowing(class_1309 owner, double distance) {
        if (distance <= 8.0) {
            this.drake.method_5942().method_6340();
            this.pathRecalcCooldown = 0;
            return;
        }
        double baseSpeed = 0.8;
        double speed = baseSpeed * (1.0 + distance / 100.0);
        speed = Math.min(speed, 1.0);
        this.updateGroundPath(owner, speed, distance);
        if (this.drake.method_5942().method_31267()) {
            this.drake.method_5993().method_6233();
            this.drake.method_5942().method_6340();
            this.pathRecalcCooldown = 0;
        }
    }

    public void method_6270() {
        this.drake.method_5942().method_6340();
        this.resetPathTracking();
    }

    private void updateGroundPath(class_1309 owner, double speed, double distance) {
        boolean navIdle;
        if (this.pathRecalcCooldown > 0) {
            --this.pathRecalcCooldown;
        }
        boolean ownerMoved = this.ownerMovedSignificantly(owner);
        boolean bl = navIdle = this.drake.method_5942().method_6357() || !this.drake.method_5942().method_23966();
        if (navIdle || ownerMoved || this.pathRecalcCooldown <= 0) {
            if (!this.drake.method_5942().method_6335((class_1297)owner, speed)) {
                this.drake.method_5942().method_6337(owner.method_23317(), owner.method_23318(), owner.method_23321(), speed);
            }
            this.rememberOwnerPosition(owner);
            this.pathRecalcCooldown = this.computeRepathCooldown(distance);
        }
    }

    private int computeRepathCooldown(double distance) {
        int base = (int)Math.ceil(distance * 0.45);
        return class_3532.method_15340((int)base, (int)6, (int)24);
    }

    private boolean ownerMovedSignificantly(class_1309 owner) {
        double dz;
        double dy;
        if (Double.isNaN(this.lastOwnerX)) {
            return true;
        }
        double dx = owner.method_23317() - this.lastOwnerX;
        return dx * dx + (dy = owner.method_23318() - this.lastOwnerY) * dy + (dz = owner.method_23321() - this.lastOwnerZ) * dz > 1.0;
    }

    private void rememberOwnerPosition(class_1309 owner) {
        this.lastOwnerX = owner.method_23317();
        this.lastOwnerY = owner.method_23318();
        this.lastOwnerZ = owner.method_23321();
    }

    private void resetPathTracking() {
        this.pathRecalcCooldown = 0;
        this.lastOwnerX = Double.NaN;
        this.lastOwnerY = Double.NaN;
        this.lastOwnerZ = Double.NaN;
    }
}

